/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.jira.utils;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import lombok.NonNull;
import org.opensearch.dataprepper.plugins.source.source_crawler.exception.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressValidation {
    private static final Logger log = LoggerFactory.getLogger(AddressValidation.class);
    public static final String INVALID_URL = "URL is not valid ";

    public static InetAddress getInetAddress(String url) {
        try {
            return InetAddress.getByName(new URL(url).getHost());
        }
        catch (MalformedURLException | UnknownHostException e) {
            log.error("{}: {}", (Object)INVALID_URL, (Object)url);
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    public static void validateInetAddress(@NonNull InetAddress address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (address.isMulticastAddress() || address.isAnyLocalAddress() || address.isLinkLocalAddress() || address.isSiteLocalAddress() || address.isLoopbackAddress()) {
            throw new BadRequestException(INVALID_URL);
        }
    }
}

