/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.jira.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class NameConfig {
    Pattern projectKeysRegex = Pattern.compile("^[A-Z0-9]+$");
    @JsonProperty(value="include")
    @Size(max=100, message="Project name type filter should not be more than 100")
    @Size(max=100, message="Project name type filter should not be more than 100") List<String> include = new ArrayList<String>();
    @JsonProperty(value="exclude")
    @Size(max=100, message="Project name type filter should not be more than 100")
    @Size(max=100, message="Project name type filter should not be more than 100") List<String> exclude = new ArrayList<String>();

    @AssertTrue(message="Jira Project keys should be alphanumeric")
    @AssertTrue(message="Jira Project keys should be alphanumeric") boolean isValidProjectKeys() {
        return this.checkGivenListForRegex(this.include) && this.checkGivenListForRegex(this.exclude);
    }

    boolean checkGivenListForRegex(List<String> list) {
        for (String value : list) {
            if (value == null || this.projectKeysRegex.matcher(value).matches()) continue;
            return false;
        }
        return true;
    }

    public Pattern getProjectKeysRegex() {
        return this.projectKeysRegex;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public List<String> getExclude() {
        return this.exclude;
    }
}

