/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch.worker.client;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.InfoResponse;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.plugin.PluginComponentRefresher;
import org.opensearch.dataprepper.model.plugin.PluginConfigObservable;
import org.opensearch.dataprepper.plugins.source.opensearch.ClientRefresher;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchSourceConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.metrics.OpenSearchSourcePluginMetrics;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.ElasticsearchAccessor;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.OpenSearchAccessor;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.OpenSearchClientFactory;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.SearchAccessor;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.DistributionVersion;
import org.opensearch.dataprepper.plugins.source.opensearch.worker.client.model.SearchContextType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAccessorStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SearchAccessorStrategy.class);
    static final String OPENSEARCH_DISTRIBUTION = "opensearch";
    static final String ELASTICSEARCH_DISTRIBUTION = "elasticsearch";
    static final String ELASTICSEARCH_OSS_BUILD_FLAVOR = "oss";
    private static final String OPENSEARCH_POINT_IN_TIME_SUPPORT_VERSION_CUTOFF = "2.5.0";
    private static final String ELASTICSEARCH_POINT_IN_TIME_SUPPORT_VERSION_CUTOFF = "7.10.0";
    private final OpenSearchClientFactory openSearchClientFactory;
    private final OpenSearchSourcePluginMetrics openSearchSourcePluginMetrics;
    private final OpenSearchSourceConfiguration openSearchSourceConfiguration;
    private final PluginConfigObservable pluginConfigObservable;

    public static SearchAccessorStrategy create(OpenSearchSourcePluginMetrics openSearchSourcePluginMetrics, OpenSearchSourceConfiguration openSearchSourceConfiguration, OpenSearchClientFactory openSearchClientFactory, PluginConfigObservable pluginConfigObservable) {
        return new SearchAccessorStrategy(openSearchSourcePluginMetrics, openSearchSourceConfiguration, openSearchClientFactory, pluginConfigObservable);
    }

    private SearchAccessorStrategy(OpenSearchSourcePluginMetrics openSearchSourcePluginMetrics, OpenSearchSourceConfiguration openSearchSourceConfiguration, OpenSearchClientFactory openSearchClientFactory, PluginConfigObservable pluginConfigObservable) {
        this.openSearchSourcePluginMetrics = openSearchSourcePluginMetrics;
        this.openSearchSourceConfiguration = openSearchSourceConfiguration;
        this.openSearchClientFactory = openSearchClientFactory;
        this.pluginConfigObservable = pluginConfigObservable;
    }

    public SearchAccessor getSearchAccessor() {
        SearchContextType searchContextType;
        ClientRefresher<OpenSearchClient> clientRefresher = new ClientRefresher<OpenSearchClient>(this.openSearchSourcePluginMetrics, OpenSearchClient.class, this.openSearchClientFactory::provideOpenSearchClient, this.openSearchSourceConfiguration);
        if (Objects.nonNull(this.openSearchSourceConfiguration.getAwsAuthenticationOptions()) && this.openSearchSourceConfiguration.getAwsAuthenticationOptions().isServerlessCollection().booleanValue()) {
            return this.createSearchAccessorForServerlessCollection(clientRefresher);
        }
        org.opensearch.client.opensearch.core.InfoResponse infoResponse = null;
        ClientRefresher<ElasticsearchClient> elasticsearchClientRefresher = null;
        try {
            infoResponse = ((OpenSearchClient)clientRefresher.get()).info();
            this.pluginConfigObservable.addPluginConfigObserver(newConfig -> clientRefresher.update((OpenSearchSourceConfiguration)newConfig));
        }
        catch (Exception e) {
            if (DistributionVersion.OPENSEARCH.equals((Object)this.openSearchSourceConfiguration.getDistributionVersion())) {
                LOG.info("distribution_version is opensearch. Forcing creation of OpenSearch client...");
                return new OpenSearchAccessor(clientRefresher, this.openSearchSourceConfiguration.getSearchConfiguration().getSearchContextType() != null ? this.openSearchSourceConfiguration.getSearchConfiguration().getSearchContextType() : SearchContextType.SCROLL);
            }
            LOG.info("Detected Elasticsearch cluster. Constructing Elasticsearch client");
            try {
                ClientRefresher<ElasticsearchClient> finalElasticsearchClientRefresher = elasticsearchClientRefresher = new ClientRefresher<ElasticsearchClient>(this.openSearchSourcePluginMetrics, ElasticsearchClient.class, this.openSearchClientFactory::provideElasticSearchClient, this.openSearchSourceConfiguration);
                this.pluginConfigObservable.addPluginConfigObserver(newConfig -> finalElasticsearchClientRefresher.update((OpenSearchSourceConfiguration)newConfig));
            }
            catch (Exception ex) {
                throw new RuntimeException("There was an error looking up the OpenSearch cluster info: ", ex);
            }
        }
        Pair<String, String> distributionAndVersion = this.getDistributionAndVersionNumber(infoResponse, elasticsearchClientRefresher);
        String distribution = (String)distributionAndVersion.getLeft();
        String versionNumber = (String)distributionAndVersion.getRight();
        this.validateDistribution(distribution);
        if (Objects.nonNull((Object)this.openSearchSourceConfiguration.getSearchConfiguration().getSearchContextType())) {
            LOG.info("Using search_context_type set in the config: '{}'", (Object)this.openSearchSourceConfiguration.getSearchConfiguration().getSearchContextType().toString().toLowerCase());
            this.validateSearchContextTypeOverride(this.openSearchSourceConfiguration.getSearchConfiguration().getSearchContextType(), distribution, versionNumber);
            searchContextType = this.openSearchSourceConfiguration.getSearchConfiguration().getSearchContextType();
        } else if (this.versionSupportsPointInTime(distribution, versionNumber)) {
            LOG.info("{} distribution and version {} detected. Point in time APIs will be used to search documents", (Object)distribution, (Object)versionNumber);
            searchContextType = SearchContextType.POINT_IN_TIME;
        } else {
            LOG.info("{} distribution, version {} detected. Scroll contexts will be used to search documents. Upgrade your cluster to at least OpenSearch {} to use Point in Time APIs instead of scroll.", new Object[]{distribution, versionNumber, OPENSEARCH_POINT_IN_TIME_SUPPORT_VERSION_CUTOFF});
            searchContextType = SearchContextType.SCROLL;
        }
        if (Objects.isNull(elasticsearchClientRefresher)) {
            return new OpenSearchAccessor(clientRefresher, searchContextType);
        }
        return new ElasticsearchAccessor(elasticsearchClientRefresher, searchContextType);
    }

    private SearchAccessor createSearchAccessorForServerlessCollection(PluginComponentRefresher clientRefresher) {
        if (Objects.isNull((Object)this.openSearchSourceConfiguration.getSearchConfiguration().getSearchContextType())) {
            LOG.info("Configured with AOS serverless flag as true, defaulting to search_context_type as 'none', which uses search_after");
            return new OpenSearchAccessor((PluginComponentRefresher<OpenSearchClient, OpenSearchSourceConfiguration>)clientRefresher, SearchContextType.NONE);
        }
        if (SearchContextType.SCROLL.equals((Object)this.openSearchSourceConfiguration.getSearchConfiguration().getSearchContextType())) {
            throw new InvalidPluginConfigurationException("A search_context_type of scroll is not supported for serverless collections");
        }
        LOG.info("Using search_context_type set in the config: '{}'", (Object)this.openSearchSourceConfiguration.getSearchConfiguration().getSearchContextType().toString().toLowerCase());
        return new OpenSearchAccessor((PluginComponentRefresher<OpenSearchClient, OpenSearchSourceConfiguration>)clientRefresher, this.openSearchSourceConfiguration.getSearchConfiguration().getSearchContextType());
    }

    private void validateSearchContextTypeOverride(SearchContextType searchContextType, String distribution, String version) {
        if (searchContextType.equals((Object)SearchContextType.POINT_IN_TIME) && !this.versionSupportsPointInTime(distribution, version)) {
            throw new IllegalArgumentException(String.format("A search_context_type of point_in_time is only supported on OpenSearch versions %s and above. The version of the OpenSearch cluster passed is %s. Elasticsearch clusters with build-flavor %s do not support point in time", distribution.startsWith(ELASTICSEARCH_DISTRIBUTION) ? ELASTICSEARCH_POINT_IN_TIME_SUPPORT_VERSION_CUTOFF : OPENSEARCH_POINT_IN_TIME_SUPPORT_VERSION_CUTOFF, version, ELASTICSEARCH_OSS_BUILD_FLAVOR));
        }
    }

    private boolean versionSupportsPointInTime(String distribution, String version) {
        DefaultArtifactVersion cutoffVersion;
        DefaultArtifactVersion actualVersion = new DefaultArtifactVersion(version);
        if (distribution.startsWith(ELASTICSEARCH_DISTRIBUTION)) {
            if (distribution.endsWith(ELASTICSEARCH_OSS_BUILD_FLAVOR)) {
                return false;
            }
            cutoffVersion = new DefaultArtifactVersion(ELASTICSEARCH_POINT_IN_TIME_SUPPORT_VERSION_CUTOFF);
        } else {
            cutoffVersion = new DefaultArtifactVersion(OPENSEARCH_POINT_IN_TIME_SUPPORT_VERSION_CUTOFF);
        }
        return actualVersion.compareTo((ArtifactVersion)cutoffVersion) >= 0;
    }

    private Pair<String, String> getDistributionAndVersionNumber(org.opensearch.client.opensearch.core.InfoResponse infoResponseOpenSearch, PluginComponentRefresher<ElasticsearchClient, OpenSearchSourceConfiguration> elasticsearchClientRefresher) {
        if (Objects.nonNull(infoResponseOpenSearch)) {
            return Pair.of((Object)infoResponseOpenSearch.version().distribution(), (Object)infoResponseOpenSearch.version().number());
        }
        try {
            InfoResponse infoResponseElasticsearch = ((ElasticsearchClient)elasticsearchClientRefresher.get()).info();
            return Pair.of((Object)("elasticsearch-" + infoResponseElasticsearch.version().buildFlavor()), (Object)infoResponseElasticsearch.version().number());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to call info API using the elasticsearch client", e);
        }
    }

    private void validateDistribution(String distribution) {
        if (!distribution.equals(OPENSEARCH_DISTRIBUTION) && !distribution.startsWith(ELASTICSEARCH_DISTRIBUTION)) {
            throw new IllegalArgumentException(String.format("Only %s or %s distributions are supported at this time. The cluster distribution being used is '%s'", OPENSEARCH_DISTRIBUTION, ELASTICSEARCH_DISTRIBUTION, distribution));
        }
    }
}

