/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.indices.ExistsTemplateRequest;
import org.opensearch.client.opensearch.indices.GetTemplateRequest;
import org.opensearch.client.opensearch.indices.GetTemplateResponse;
import org.opensearch.client.opensearch.indices.OpenSearchIndicesClient;
import org.opensearch.client.opensearch.indices.PutTemplateRequest;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplate;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexTemplateAPIWrapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.LegacyIndexTemplate;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.PutTemplateRequestDeserializer;

public class OpenSearchLegacyTemplateAPIWrapper
implements IndexTemplateAPIWrapper<GetTemplateResponse> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final OpenSearchClient openSearchClient;

    public OpenSearchLegacyTemplateAPIWrapper(OpenSearchClient openSearchClient) {
        this.openSearchClient = openSearchClient;
    }

    @Override
    public void putTemplate(IndexTemplate indexTemplate) throws IOException {
        if (!(indexTemplate instanceof LegacyIndexTemplate)) {
            throw new IllegalArgumentException("Unexpected indexTemplate provided to createTemplate.");
        }
        Map<String, Object> templateMapping = ((LegacyIndexTemplate)indexTemplate).getTemplateMap();
        String indexTemplateString = OBJECT_MAPPER.writeValueAsString(templateMapping);
        ByteArrayInputStream byteIn = new ByteArrayInputStream(indexTemplateString.getBytes(StandardCharsets.UTF_8));
        JsonpMapper mapper = ((OpenSearchTransport)this.openSearchClient._transport()).jsonpMapper();
        JsonParser parser = mapper.jsonProvider().createParser((InputStream)byteIn);
        PutTemplateRequest putTemplateRequest = (PutTemplateRequest)PutTemplateRequestDeserializer.getJsonpDeserializer().deserialize(parser, mapper);
        OpenSearchIndicesClient openSearchIndicesClient = this.openSearchClient.indices();
        openSearchIndicesClient.putTemplate(putTemplateRequest);
    }

    @Override
    public Optional<GetTemplateResponse> getTemplate(String templateName) throws IOException {
        ExistsTemplateRequest existsTemplateRequest = new ExistsTemplateRequest.Builder().name(templateName, new String[0]).build();
        BooleanResponse booleanResponse = this.openSearchClient.indices().existsTemplate(existsTemplateRequest);
        if (!booleanResponse.value()) {
            return Optional.empty();
        }
        GetTemplateRequest getTemplateRequest = new GetTemplateRequest.Builder().name(templateName, new String[0]).build();
        return Optional.of(this.openSearchClient.indices().getTemplate(getTemplateRequest));
    }
}

