/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import com.google.common.base.Preconditions;
import io.micrometer.core.instrument.util.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.ExistsRequest;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.AbstractIndexManager;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IsmPolicyManagementStrategy;

class NoIsmPolicyManagement
implements IsmPolicyManagementStrategy {
    private final RestHighLevelClient restHighLevelClient;
    private final OpenSearchClient openSearchClient;

    public NoIsmPolicyManagement(OpenSearchClient openSearchClient, RestHighLevelClient restHighLevelClient) {
        Preconditions.checkNotNull((Object)restHighLevelClient);
        Preconditions.checkNotNull((Object)openSearchClient);
        this.openSearchClient = openSearchClient;
        this.restHighLevelClient = restHighLevelClient;
    }

    @Override
    public Optional<String> checkAndCreatePolicy() throws IOException {
        return Optional.empty();
    }

    @Override
    public List<String> getIndexPatterns(String indexAlias) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)indexAlias));
        return Collections.singletonList(AbstractIndexManager.TIME_PATTERN.matcher(indexAlias).replaceAll("*"));
    }

    @Override
    public boolean checkIfIndexExistsOnServer(String indexAlias) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)indexAlias));
        BooleanResponse booleanResponse = this.openSearchClient.indices().exists(new ExistsRequest.Builder().index(indexAlias, new String[0]).build());
        return booleanResponse.value();
    }

    @Override
    public CreateIndexRequest getCreateIndexRequest(String indexAlias) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)indexAlias));
        String initialIndexName = indexAlias;
        return new CreateIndexRequest.Builder().index(initialIndexName).build();
    }
}

