/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.bulk;

import com.fasterxml.jackson.core.JsonGenerator;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.OutputStream;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonProvider;
import org.opensearch.client.json.jackson.JacksonJsonpGenerator;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.dataprepper.plugins.sink.opensearch.bulk.SerializedJson;

public class PreSerializedJsonpMapper
implements JsonpMapper {
    private final JsonpMapper innerMapper = new JacksonJsonpMapper();
    private final PreSerializedJsonProvider jsonProvider = new PreSerializedJsonProvider();

    public JsonProvider jsonProvider() {
        return this.jsonProvider;
    }

    public <T> T deserialize(JsonParser parser, Class<T> clazz) {
        return (T)this.innerMapper.deserialize(parser, clazz);
    }

    public <T> void serialize(T value, jakarta.json.stream.JsonGenerator generator) {
        if (value instanceof SerializedJson) {
            if (!(generator instanceof PreSerializedJsonGenerator)) {
                throw new IllegalArgumentException("Unsupported JsonGenerator");
            }
            OutputStream outputStream = ((PreSerializedJsonGenerator)generator).outputStream;
            try {
                outputStream.write(((SerializedJson)value).getSerializedJson());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.innerMapper.serialize(value, generator);
        }
    }

    private static class PreSerializedJsonProvider
    extends JacksonJsonProvider {
        private PreSerializedJsonProvider() {
        }

        public jakarta.json.stream.JsonGenerator createGenerator(OutputStream out) {
            try {
                return new PreSerializedJsonGenerator(this.jacksonJsonFactory().createGenerator(out), out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PreSerializedJsonGenerator
    extends JacksonJsonpGenerator {
        private OutputStream outputStream;

        public PreSerializedJsonGenerator(JsonGenerator generator, OutputStream outputStream) {
            super(generator);
            this.outputStream = outputStream;
        }
    }
}

