/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch;

import io.micrometer.core.instrument.Counter;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.plugin.PluginComponentRefresher;
import org.opensearch.dataprepper.plugins.sink.opensearch.ConnectionConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.configuration.OpenSearchSinkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchClientRefresher
implements PluginComponentRefresher<OpenSearchClient, OpenSearchSinkConfig> {
    static final String CREDENTIALS_CHANGED = "credentialsChanged";
    static final String CLIENT_REFRESH_ERRORS = "clientRefreshErrors";
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchClientRefresher.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Function<ConnectionConfiguration, OpenSearchClient> clientFunction;
    private OpenSearchClient currentClient;
    private ConnectionConfiguration currentConfig;
    private final Counter credentialsChangeCounter;
    private final Counter clientRefreshErrorsCounter;

    public OpenSearchClientRefresher(PluginMetrics pluginMetrics, ConnectionConfiguration connectionConfiguration, Function<ConnectionConfiguration, OpenSearchClient> clientFunction) {
        this.clientFunction = clientFunction;
        this.currentConfig = connectionConfiguration;
        this.currentClient = null;
        this.credentialsChangeCounter = pluginMetrics.counter(CREDENTIALS_CHANGED);
        this.clientRefreshErrorsCounter = pluginMetrics.counter(CLIENT_REFRESH_ERRORS);
    }

    public Class<OpenSearchClient> getComponentClass() {
        return OpenSearchClient.class;
    }

    public OpenSearchClient get() {
        this.readWriteLock.readLock().lock();
        try {
            if (this.currentClient == null) {
                this.currentClient = this.clientFunction.apply(this.currentConfig);
            }
            OpenSearchClient openSearchClient = this.currentClient;
            return openSearchClient;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(OpenSearchSinkConfig openSearchSinkConfig) {
        ConnectionConfiguration newConfig = ConnectionConfiguration.readConnectionConfiguration(openSearchSinkConfig);
        if (this.basicAuthChanged(newConfig)) {
            this.credentialsChangeCounter.increment();
            this.readWriteLock.writeLock().lock();
            try {
                this.currentClient = this.clientFunction.apply(newConfig);
                this.currentConfig = newConfig;
            }
            catch (Exception e) {
                this.clientRefreshErrorsCounter.increment();
                LOG.error("Refreshing {} failed.", this.getComponentClass(), (Object)e);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    private boolean basicAuthChanged(ConnectionConfiguration newConfig) {
        String newPassword;
        String newUsername;
        String existingPassword;
        String existingUsername;
        if (this.currentConfig.getAuthConfig() != null) {
            existingUsername = this.currentConfig.getAuthConfig().getUsername();
            existingPassword = this.currentConfig.getAuthConfig().getPassword();
        } else {
            existingUsername = this.currentConfig.getUsername();
            existingPassword = this.currentConfig.getPassword();
        }
        if (newConfig.getAuthConfig() != null) {
            newUsername = newConfig.getAuthConfig().getUsername();
            newPassword = newConfig.getAuthConfig().getPassword();
        } else {
            newUsername = newConfig.getUsername();
            newPassword = newConfig.getPassword();
        }
        return !Objects.equals(existingUsername, newUsername) || !Objects.equals(existingPassword, newPassword);
    }
}

