/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.config.AwsConfig;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.config.ThresholdConfig;
import org.opensearch.dataprepper.plugins.sink.cloudwatch_logs.config.ValidCustomHeaders;

public class CloudWatchLogsSinkConfig {
    public static final int DEFAULT_RETRY_COUNT = 5;
    public static final int DEFAULT_NUM_WORKERS = 10;
    @JsonProperty(value="aws")
    @Valid
    private AwsConfig awsConfig;
    @JsonProperty(value="dlq")
    private PluginModel dlq;
    @JsonProperty(value="threshold")
    @Valid
    private ThresholdConfig thresholdConfig = new ThresholdConfig();
    @JsonProperty(value="log_group")
    @NotEmpty
    @NotNull
    private String logGroup;
    @JsonProperty(value="log_stream")
    @NotEmpty
    @NotNull
    private String logStream;
    @JsonProperty(value="max_retries", defaultValue="5")
    @Min(value=1L)
    @Max(value=15L)
    private @Min(value=1L) @Max(value=15L) int maxRetries = 5;
    @JsonProperty(value="workers", defaultValue="10")
    @Min(value=1L)
    @Max(value=50L)
    private @Min(value=1L) @Max(value=50L) int workers = 10;
    @JsonProperty(value="header_overrides")
    @Size(max=10, message="Maximum 10 custom headers allowed")
    @ValidCustomHeaders
    private @Size(max=10, message="Maximum 10 custom headers allowed") Map<String, String> headerOverrides = new HashMap<String, String>();
    @JsonProperty(value="endpoint")
    private String endpoint;

    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    public ThresholdConfig getThresholdConfig() {
        return this.thresholdConfig;
    }

    public PluginModel getDlq() {
        return this.dlq;
    }

    public String getLogGroup() {
        return this.logGroup;
    }

    public String getLogStream() {
        return this.logStream;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getWorkers() {
        return this.workers;
    }

    public Map<String, String> getHeaderOverrides() {
        return this.headerOverrides;
    }

    public String getEndpoint() {
        return this.endpoint;
    }
}

