/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import java.time.Duration;
import org.opensearch.dataprepper.plugins.source.s3.S3SourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class S3ClientBuilderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(S3ClientBuilderFactory.class);
    private final S3SourceConfig s3SourceConfig;
    private final AwsCredentialsProvider credentialsProvider;
    private final S3Client s3Client;
    private final S3AsyncClient s3AsyncClient;

    public S3ClientBuilderFactory(S3SourceConfig s3SourceConfig, AwsCredentialsProvider credentialsProvider) {
        this.s3SourceConfig = s3SourceConfig;
        this.credentialsProvider = credentialsProvider;
        this.s3Client = this.createS3Client();
        this.s3AsyncClient = this.createS3AsyncClient();
    }

    public S3Client createS3Client() {
        LOG.info("Creating S3 client");
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(this.s3SourceConfig.getAwsAuthenticationOptions().getAwsRegion())).crossRegionAccessEnabled(Boolean.valueOf(true))).credentialsProvider(this.credentialsProvider)).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(retryPolicy -> retryPolicy.numRetries(Integer.valueOf(5)).build()).build())).build();
    }

    public S3AsyncClient createS3AsyncClient() {
        LOG.info("Creating S3 Async client");
        return (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().region(this.s3SourceConfig.getAwsAuthenticationOptions().getAwsRegion())).crossRegionAccessEnabled(Boolean.valueOf(true))).httpClient(NettyNioAsyncHttpClient.builder().maxConcurrency(Integer.valueOf(200)).connectionTimeout(Duration.ofMinutes(1L)).build())).credentialsProvider(this.credentialsProvider)).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(retryPolicy -> retryPolicy.numRetries(Integer.valueOf(5)).build()).build())).build();
    }

    public S3Client getS3Client() {
        return this.s3Client;
    }

    public S3AsyncClient getS3AsyncClient() {
        return this.s3AsyncClient;
    }
}

