/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.dataprepper.logstash.mapping.AbstractLogstashPluginAttributesMapper;
import org.opensearch.dataprepper.logstash.mapping.LogstashAttributesMappings;
import org.opensearch.dataprepper.logstash.model.LogstashAttribute;

public class CsvLogstashPluginAttributesMapper
extends AbstractLogstashPluginAttributesMapper {
    protected static final String LOGSTASH_AUTOGENERATE_COLUMN_NAMES_ATTRIBUTE_NAME = "autogenerate_column_names";
    protected static final String LOGSTASH_COLUMNS_ATTRIBUTE_NAME = "columns";
    protected static final String DATA_PREPPER_COLUMN_NAMES = "column_names";

    @Override
    protected void mapCustomAttributes(List<LogstashAttribute> logstashAttributes, LogstashAttributesMappings logstashAttributesMappings, Map<String, Object> pluginSettings) {
        Optional<LogstashAttribute> autogenerateColumnNamesAttribute = this.findLogstashAttribute(logstashAttributes, LOGSTASH_AUTOGENERATE_COLUMN_NAMES_ATTRIBUTE_NAME);
        Object autogenerateColumnNamesValue = autogenerateColumnNamesAttribute.map(attribute -> attribute.getAttributeValue().getValue()).orElse(false);
        boolean isAutogenerateColumnNames = autogenerateColumnNamesValue.equals(true);
        Optional<LogstashAttribute> columnsAttribute = this.findLogstashAttribute(logstashAttributes, LOGSTASH_COLUMNS_ATTRIBUTE_NAME);
        List columnsValue = columnsAttribute.map(attribute -> attribute.getAttributeValue().getValue()).orElse(Collections.emptyList());
        boolean columnsValueIsEmptyOrDoesNotExist = columnsValue.isEmpty();
        if (isAutogenerateColumnNames && columnsValueIsEmptyOrDoesNotExist) {
            pluginSettings.put(DATA_PREPPER_COLUMN_NAMES, new ArrayList());
        }
    }

    private Optional<LogstashAttribute> findLogstashAttribute(List<LogstashAttribute> logstashAttributes, String logstashAttributeName) {
        return logstashAttributes.stream().filter(logstashAttribute -> logstashAttribute.getAttributeName().equals(logstashAttributeName)).findFirst();
    }

    @Override
    protected HashSet<String> getCustomMappedAttributeNames() {
        return new HashSet<String>(Collections.singleton(LOGSTASH_AUTOGENERATE_COLUMN_NAMES_ATTRIBUTE_NAME));
    }
}

