/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kinesis.source.apihandler;

import com.amazonaws.SdkClientException;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import lombok.NonNull;
import org.opensearch.dataprepper.plugins.kinesis.source.apihandler.KinesisClientApiRetryHandler;
import org.opensearch.dataprepper.plugins.kinesis.source.exceptions.KinesisConsumerNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse;
import software.amazon.awssdk.services.kinesis.model.KinesisException;
import software.amazon.awssdk.services.kinesis.model.StreamDescriptionSummary;
import software.amazon.kinesis.common.StreamIdentifier;

public class KinesisClientApiHandler {
    private static final Logger log = LoggerFactory.getLogger(KinesisClientApiHandler.class);
    private static final String COLON = ":";
    private final KinesisAsyncClient kinesisClient;
    private final KinesisClientApiRetryHandler kinesisClientApiRetryHandler;

    public KinesisClientApiHandler(@NonNull KinesisAsyncClient kinesisClient, @NonNull KinesisClientApiRetryHandler kinesisClientApiRetryHandler) {
        if (kinesisClient == null) {
            throw new NullPointerException("kinesisClient is marked non-null but is null");
        }
        if (kinesisClientApiRetryHandler == null) {
            throw new NullPointerException("kinesisClientApiRetryHandler is marked non-null but is null");
        }
        this.kinesisClient = kinesisClient;
        this.kinesisClientApiRetryHandler = kinesisClientApiRetryHandler;
    }

    public StreamIdentifier getStreamIdentifier(String streamNameOrArn) {
        if (this.isArn(streamNameOrArn)) {
            return this.getStreamIdentifierFromArn(streamNameOrArn);
        }
        return this.getStreamIdentifierFromName(streamNameOrArn);
    }

    public String getConsumerArnForStream(String streamArn, String consumerName) {
        if (Objects.isNull(streamArn) || streamArn.trim().isEmpty()) {
            throw new IllegalArgumentException("Stream ARN cannot be null or empty");
        }
        if (Objects.isNull(consumerName) || consumerName.trim().isEmpty()) {
            throw new IllegalArgumentException("Consumer name cannot be null or empty");
        }
        DescribeStreamConsumerResponse response = this.describeStreamConsumer(streamArn, consumerName);
        if (Objects.isNull(response)) {
            throw new KinesisConsumerNotFoundException(String.format("Kinesis stream consumer not found for %s", consumerName));
        }
        return response.consumerDescription().consumerARN();
    }

    private boolean isArn(String streamNameOrArn) {
        try {
            Arn.fromString((String)streamNameOrArn);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private StreamIdentifier getStreamIdentifierFromArn(String streamArnString) {
        Arn streamArn = Arn.fromString((String)streamArnString);
        String streamName = streamArn.resource().resource();
        DescribeStreamSummaryResponse response = this.getStreamDescriptionSummary(this.buildStreamSummaryRequest(streamName, streamArnString));
        return StreamIdentifier.multiStreamInstance((Arn)streamArn, (long)response.streamDescriptionSummary().streamCreationTimestamp().getEpochSecond());
    }

    private StreamIdentifier getStreamIdentifierFromName(String streamName) {
        DescribeStreamSummaryResponse response = this.getStreamDescriptionSummary(this.buildStreamSummaryRequest(streamName, null));
        StreamDescriptionSummary summary = response.streamDescriptionSummary();
        return StreamIdentifier.multiStreamInstance((String)this.createStreamIdentifierString(summary));
    }

    private DescribeStreamSummaryRequest buildStreamSummaryRequest(String streamName, String streamArn) {
        return (DescribeStreamSummaryRequest)DescribeStreamSummaryRequest.builder().streamName(streamName).streamARN(streamArn).build();
    }

    private String createStreamIdentifierString(StreamDescriptionSummary summary) {
        String accountId = (String)Arn.fromString((String)summary.streamARN()).accountId().get();
        long creationEpochSecond = summary.streamCreationTimestamp().getEpochSecond();
        return String.join((CharSequence)COLON, accountId, summary.streamName(), String.valueOf(creationEpochSecond));
    }

    private DescribeStreamSummaryResponse getStreamDescriptionSummary(DescribeStreamSummaryRequest request) {
        return this.kinesisClientApiRetryHandler.executeWithRetry("getStreamDescriptionSummary", () -> (DescribeStreamSummaryResponse)this.kinesisClient.describeStreamSummary(request).join(), (ex, attempt) -> this.handleStreamSummaryException((CompletionException)ex, request.streamName()));
    }

    private void handleStreamSummaryException(CompletionException ex, String streamName) {
        Throwable cause = ex.getCause();
        if (cause instanceof KinesisException || cause instanceof SdkClientException) {
            log.error("AWS error while describing stream summary for stream {}: {}", (Object)streamName, (Object)ex.getMessage());
        } else {
            log.error("Unexpected error while describing stream summary for stream {}", (Object)streamName, (Object)ex);
        }
    }

    private DescribeStreamConsumerResponse describeStreamConsumer(String streamArn, String consumerName) {
        DescribeStreamConsumerRequest request = (DescribeStreamConsumerRequest)DescribeStreamConsumerRequest.builder().streamARN(streamArn).consumerName(consumerName).build();
        return this.kinesisClientApiRetryHandler.executeWithRetry("describeStreamConsumer", () -> (DescribeStreamConsumerResponse)this.kinesisClient.describeStreamConsumer(request).join(), (ex, attempt) -> this.handleConsumerException((CompletionException)ex, streamArn, attempt));
    }

    private void handleConsumerException(CompletionException ex, String streamArn, int attempt) {
        Throwable cause = ex.getCause();
        if (cause instanceof KinesisException || cause instanceof SdkClientException) {
            log.error("AWS error while describing stream consumer for stream {}: {}. Attempt {}.", new Object[]{streamArn, ex.getMessage(), attempt + 1});
        } else {
            log.error("Unexpected error while describing stream consumer for stream {}. Attempt {} of {}.", new Object[]{streamArn, attempt + 1, ex});
        }
    }
}

