/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.Closeable;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.mapdb.DataIO;

public abstract class DataInput2
implements DataInput {
    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        return this.readUTF();
    }

    @Override
    public String readUTF() throws IOException {
        int len = this.unpackInt();
        char[] b = new char[len];
        for (int i = 0; i < len; ++i) {
            b[i] = (char)this.unpackInt();
        }
        return new String(b);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readChar();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public abstract int getPos();

    public abstract void setPos(int var1);

    public abstract byte[] internalByteArray();

    public abstract java.nio.ByteBuffer internalByteBuffer();

    public abstract void close();

    public abstract long unpackLong() throws IOException;

    public abstract int unpackInt() throws IOException;

    public abstract long[] unpackLongArrayDeltaCompression(int var1) throws IOException;

    public abstract void unpackLongArray(long[] var1, int var2, int var3) throws IOException;

    public abstract void unpackIntArray(int[] var1, int var2, int var3) throws IOException;

    public abstract void unpackLongSkip(int var1) throws IOException;

    public static final class Stream
    extends DataInput2 {
        private final InputStream ins;

        public Stream(InputStream ins) {
            this.ins = ins;
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            DataIO.readFully(this.ins, b, off, len);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return (int)this.ins.skip(n);
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.readByte() == 1;
        }

        @Override
        public byte readByte() throws IOException {
            int read = this.ins.read();
            if (read == -1) {
                throw new EOFException();
            }
            return (byte)(read & 0xFF);
        }

        @Override
        public int readUnsignedByte() throws IOException {
            int read = this.ins.read();
            if (read == -1) {
                throw new EOFException();
            }
            return read;
        }

        @Override
        public short readShort() throws IOException {
            return (short)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
        }

        @Override
        public char readChar() throws IOException {
            return (char)(this.readUnsignedByte() << 8 | this.readUnsignedByte() & 0xFF);
        }

        @Override
        public int readInt() throws IOException {
            int ret = this.readUnsignedByte() << 24 | (this.readUnsignedByte() & 0xFF) << 16 | (this.readUnsignedByte() & 0xFF) << 8 | this.readUnsignedByte() & 0xFF;
            return ret;
        }

        @Override
        public long readLong() throws IOException {
            long ret = (long)this.readUnsignedByte() << 56 | ((long)this.readUnsignedByte() & 0xFFL) << 48 | ((long)this.readUnsignedByte() & 0xFFL) << 40 | ((long)this.readUnsignedByte() & 0xFFL) << 32 | ((long)this.readUnsignedByte() & 0xFFL) << 24 | ((long)this.readUnsignedByte() & 0xFFL) << 16 | ((long)this.readUnsignedByte() & 0xFFL) << 8 | (long)this.readUnsignedByte() & 0xFFL;
            return ret;
        }

        @Override
        public long[] unpackLongArrayDeltaCompression(int size) throws IOException {
            long[] ret = new long[size];
            long prev = 0L;
            for (int i = 0; i < size; ++i) {
                ret[i] = prev += this.unpackLong();
            }
            return ret;
        }

        @Override
        public void unpackLongArray(long[] array, int start, int end) throws IOException {
            while (start < end) {
                array[start] = this.unpackLong();
                ++start;
            }
        }

        @Override
        public void unpackIntArray(int[] array, int start, int end) throws IOException {
            while (start < end) {
                array[start] = this.unpackInt();
                ++start;
            }
        }

        @Override
        public void unpackLongSkip(int count) throws IOException {
            while (count-- > 0) {
                this.unpackLong();
            }
        }

        @Override
        public int getPos() {
            throw new UnsupportedOperationException("InputStream does not support pos");
        }

        @Override
        public void setPos(int pos) {
            throw new UnsupportedOperationException("InputStream does not support pos");
        }

        @Override
        public byte[] internalByteArray() {
            return null;
        }

        @Override
        public java.nio.ByteBuffer internalByteBuffer() {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public long unpackLong() throws IOException {
            return DataIO.unpackLong(this.ins);
        }

        @Override
        public int unpackInt() throws IOException {
            return DataIO.unpackInt(this.ins);
        }
    }

    public static final class ByteBuffer
    extends DataInput2 {
        public final java.nio.ByteBuffer buf;
        public int pos;

        public ByteBuffer(java.nio.ByteBuffer buf, int pos) {
            this.buf = buf;
            this.pos = pos;
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            java.nio.ByteBuffer clone = this.buf.duplicate();
            clone.position(this.pos);
            this.pos += len;
            clone.get(b, off, len);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            this.pos += n;
            return n;
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.buf.get(this.pos++) == 1;
        }

        @Override
        public byte readByte() throws IOException {
            return this.buf.get(this.pos++);
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.buf.get(this.pos++) & 0xFF;
        }

        @Override
        public short readShort() throws IOException {
            short ret = this.buf.getShort(this.pos);
            this.pos += 2;
            return ret;
        }

        @Override
        public char readChar() throws IOException {
            return (char)((this.buf.get(this.pos++) & 0xFF) << 8 | this.buf.get(this.pos++) & 0xFF);
        }

        @Override
        public int readInt() throws IOException {
            int ret = this.buf.getInt(this.pos);
            this.pos += 4;
            return ret;
        }

        @Override
        public long readLong() throws IOException {
            long ret = this.buf.getLong(this.pos);
            this.pos += 8;
            return ret;
        }

        @Override
        public int getPos() {
            return this.pos;
        }

        @Override
        public void setPos(int pos) {
            this.pos = pos;
        }

        @Override
        public byte[] internalByteArray() {
            return null;
        }

        @Override
        public java.nio.ByteBuffer internalByteBuffer() {
            return this.buf;
        }

        @Override
        public void close() {
        }

        @Override
        public long unpackLong() throws IOException {
            byte v;
            long ret = 0L;
            do {
                v = this.buf.get(this.pos++);
                ret = ret << 7 | (long)(v & 0x7F);
            } while ((v & 0x80) == 0);
            return ret;
        }

        @Override
        public int unpackInt() throws IOException {
            byte v;
            int ret = 0;
            do {
                v = this.buf.get(this.pos++);
                ret = ret << 7 | v & 0x7F;
            } while ((v & 0x80) == 0);
            return ret;
        }

        @Override
        public long[] unpackLongArrayDeltaCompression(int size) throws IOException {
            long[] ret = new long[size];
            int pos2 = this.pos;
            java.nio.ByteBuffer buf2 = this.buf;
            long prev = 0L;
            for (int i = 0; i < size; ++i) {
                byte v;
                long r = 0L;
                do {
                    v = buf2.get(pos2++);
                    r = r << 7 | (long)(v & 0x7F);
                } while ((v & 0x80) == 0);
                ret[i] = prev += r;
            }
            this.pos = pos2;
            return ret;
        }

        @Override
        public void unpackLongArray(long[] array, int start, int end) {
            int pos2 = this.pos;
            java.nio.ByteBuffer buf2 = this.buf;
            while (start < end) {
                byte v;
                long ret = 0L;
                do {
                    v = buf2.get(pos2++);
                    ret = ret << 7 | (long)(v & 0x7F);
                } while ((v & 0x80) == 0);
                array[start] = ret;
                ++start;
            }
            this.pos = pos2;
        }

        @Override
        public void unpackLongSkip(int count) {
            java.nio.ByteBuffer buf2 = this.buf;
            int pos2 = this.pos;
            while (count > 0) {
                count -= (buf2.get(pos2++) & 0x80) >> 7;
            }
            this.pos = pos2;
        }

        @Override
        public void unpackIntArray(int[] array, int start, int end) {
            int pos2 = this.pos;
            java.nio.ByteBuffer buf2 = this.buf;
            while (start < end) {
                byte v;
                int ret = 0;
                do {
                    v = buf2.get(pos2++);
                    ret = ret << 7 | v & 0x7F;
                } while ((v & 0x80) == 0);
                array[start] = ret;
                ++start;
            }
            this.pos = pos2;
        }
    }

    public static final class DataInputToStream
    extends InputStream {
        protected final DataInput in;

        public DataInputToStream(DataInput in) {
            this.in = in;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.in.readFully(b, off, len);
            return len;
        }

        @Override
        public long skip(long n) throws IOException {
            n = Math.min(n, Integer.MAX_VALUE);
            return this.in.skipBytes((int)n);
        }

        @Override
        public void close() throws IOException {
            if (this.in instanceof Closeable) {
                ((Closeable)((Object)this.in)).close();
            }
        }

        @Override
        public int read() throws IOException {
            return this.in.readUnsignedByte();
        }
    }

    public static final class ByteArray
    extends DataInput2 {
        protected final byte[] buf;
        public int pos;

        public ByteArray(byte[] b) {
            this(b, 0);
        }

        public ByteArray(byte[] bb, int pos) {
            this.buf = bb;
            this.pos = pos;
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
        }

        @Override
        public int skipBytes(int n) throws IOException {
            this.pos += n;
            return n;
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.buf[this.pos++] == 1;
        }

        @Override
        public byte readByte() throws IOException {
            return this.buf[this.pos++];
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.buf[this.pos++] & 0xFF;
        }

        @Override
        public short readShort() throws IOException {
            return (short)(this.buf[this.pos++] << 8 | this.buf[this.pos++] & 0xFF);
        }

        @Override
        public char readChar() throws IOException {
            return (char)((this.buf[this.pos++] & 0xFF) << 8 | this.buf[this.pos++] & 0xFF);
        }

        @Override
        public int readInt() throws IOException {
            int p = this.pos;
            byte[] b = this.buf;
            int ret = b[p++] << 24 | (b[p++] & 0xFF) << 16 | (b[p++] & 0xFF) << 8 | b[p++] & 0xFF;
            this.pos = p;
            return ret;
        }

        @Override
        public long readLong() throws IOException {
            int p = this.pos;
            byte[] b = this.buf;
            long ret = (long)b[p++] << 56 | ((long)b[p++] & 0xFFL) << 48 | ((long)b[p++] & 0xFFL) << 40 | ((long)b[p++] & 0xFFL) << 32 | ((long)b[p++] & 0xFFL) << 24 | ((long)b[p++] & 0xFFL) << 16 | ((long)b[p++] & 0xFFL) << 8 | (long)b[p++] & 0xFFL;
            this.pos = p;
            return ret;
        }

        @Override
        public int getPos() {
            return this.pos;
        }

        @Override
        public void setPos(int pos) {
            this.pos = pos;
        }

        @Override
        public byte[] internalByteArray() {
            return this.buf;
        }

        @Override
        public java.nio.ByteBuffer internalByteBuffer() {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public long unpackLong() throws IOException {
            byte v;
            byte[] b = this.buf;
            int p = this.pos;
            long ret = 0L;
            do {
                v = b[p++];
                ret = ret << 7 | (long)(v & 0x7F);
            } while ((v & 0x80) == 0);
            this.pos = p;
            return ret;
        }

        @Override
        public void unpackLongSkip(int count) {
            byte[] b = this.buf;
            int pos2 = this.pos;
            while (count > 0) {
                count -= (b[pos2++] & 0x80) >> 7;
            }
            this.pos = pos2;
        }

        @Override
        public int unpackInt() throws IOException {
            byte v;
            byte[] b = this.buf;
            int p = this.pos;
            int ret = 0;
            do {
                v = b[p++];
                ret = ret << 7 | v & 0x7F;
            } while ((v & 0x80) == 0);
            this.pos = p;
            return ret;
        }

        @Override
        public long[] unpackLongArrayDeltaCompression(int size) throws IOException {
            long[] ret = new long[size];
            int pos2 = this.pos;
            byte[] buf2 = this.buf;
            long prev = 0L;
            for (int i = 0; i < size; ++i) {
                byte v;
                long r = 0L;
                do {
                    v = buf2[pos2++];
                    r = r << 7 | (long)(v & 0x7F);
                } while ((v & 0x80) == 0);
                ret[i] = prev += r;
            }
            this.pos = pos2;
            return ret;
        }

        @Override
        public void unpackLongArray(long[] array, int start, int end) {
            int pos2 = this.pos;
            byte[] buf2 = this.buf;
            while (start < end) {
                byte v;
                long ret = 0L;
                do {
                    v = buf2[pos2++];
                    ret = ret << 7 | (long)(v & 0x7F);
                } while ((v & 0x80) == 0);
                array[start] = ret;
                ++start;
            }
            this.pos = pos2;
        }

        @Override
        public void unpackIntArray(int[] array, int start, int end) {
            int pos2 = this.pos;
            byte[] buf2 = this.buf;
            while (start < end) {
                byte v;
                int ret = 0;
                do {
                    v = buf2[pos2++];
                    ret = ret << 7 | v & 0x7F;
                } while ((v & 0x80) == 0);
                array[start] = ret;
                ++start;
            }
            this.pos = pos2;
        }
    }
}

