/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.codec;

import io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.List;
import java.util.function.Consumer;
import org.opensearch.dataprepper.model.codec.ByteDecoder;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.log.OpenTelemetryLog;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.otel.codec.OTelOutputFormat;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoOpensearchCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoStandardCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTelLogsProtoBufDecoder
implements ByteDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(OTelLogsProtoBufDecoder.class);
    private static final int MAX_REQUEST_LEN = 0x800000;
    private final OTelProtoCodec.OTelProtoDecoder otelProtoDecoder;
    private final boolean lengthPrefixedEncoding;

    public OTelLogsProtoBufDecoder(OTelOutputFormat otelOutputFormat, boolean lengthPrefixedEncoding) {
        this.otelProtoDecoder = otelOutputFormat == OTelOutputFormat.OPENSEARCH ? new OTelProtoOpensearchCodec.OTelProtoDecoder() : new OTelProtoStandardCodec.OTelProtoDecoder();
        this.lengthPrefixedEncoding = lengthPrefixedEncoding;
    }

    private void parseRequest(ExportLogsServiceRequest request, Instant timeReceivedMs, Consumer<Record<Event>> eventConsumer) throws IOException {
        List<OpenTelemetryLog> logs = this.otelProtoDecoder.parseExportLogsServiceRequest(request, timeReceivedMs);
        for (OpenTelemetryLog log : logs) {
            eventConsumer.accept((Record<Event>)new Record((Object)log));
        }
    }

    public void parse(InputStream inputStream, Instant timeReceivedMs, Consumer<Record<Event>> eventConsumer) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream);
        ExportLogsServiceRequest.Builder builder = ExportLogsServiceRequest.newBuilder();
        if (!this.lengthPrefixedEncoding) {
            int available = inputStream.available();
            if (available > 0x800000) {
                throw new IllegalArgumentException("buffer length " + available + " exceeds max allowed buffer length of 8388608");
            }
            ExportLogsServiceRequest request = ExportLogsServiceRequest.parseFrom((InputStream)inputStream);
            this.parseRequest(request, timeReceivedMs, eventConsumer);
            return;
        }
        byte[] lenBytes = new byte[4];
        while (inputStream.read(lenBytes, 0, 4) == 4) {
            ByteBuffer lengthBuffer = ByteBuffer.wrap(lenBytes);
            int len = lengthBuffer.getInt();
            if (len > 0x800000) {
                throw new IllegalArgumentException("buffer length " + len + " exceeds max allowed buffer length of 8388608");
            }
            byte[] buffer = new byte[len];
            if (inputStream.read(buffer, 0, len) != len) {
                LOG.warn("Failed to read {} bytes", (Object)len);
                continue;
            }
            ExportLogsServiceRequest request = ExportLogsServiceRequest.parseFrom((byte[])buffer);
            this.parseRequest(request, timeReceivedMs, eventConsumer);
        }
    }
}

