/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.codec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum OTelLogsFormatOption {
    JSON("json"),
    PROTOBUF("protobuf");

    private static final Map<String, OTelLogsFormatOption> NAMES_MAP;
    private final String optionName;

    private OTelLogsFormatOption(String optionName) {
        this.optionName = optionName;
    }

    @JsonValue
    public String getFormatName() {
        return this.optionName;
    }

    @JsonCreator
    public static OTelLogsFormatOption fromFormatName(String optionName) {
        return NAMES_MAP.get(optionName);
    }

    static {
        NAMES_MAP = Arrays.stream(OTelLogsFormatOption.values()).collect(Collectors.toMap(value -> value.optionName, value -> value));
    }
}

