/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.anomalydetector.modes;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import jakarta.validation.constraints.AssertTrue;
import java.util.HashSet;
import java.util.Set;
import org.opensearch.dataprepper.plugins.processor.anomalydetector.modes.RandomCutForestType;

public class RandomCutForestModeConfig {
    public static final String DEFAULT_TYPE = "metrics";
    public static final int DEFAULT_SHINGLE_SIZE = 4;
    private static final int MIN_SHINGLE_SIZE = 1;
    public static final int MAX_SHINGLE_SIZE = 60;
    public static final int DEFAULT_SAMPLE_SIZE = 256;
    private static final int MIN_SAMPLE_SIZE = 100;
    public static final int MAX_SAMPLE_SIZE = 2500;
    public static final double DEFAULT_TIME_DECAY = 0.1;
    private static final double MIN_TIME_DECAY = 0.0;
    public static final double MAX_TIME_DECAY = 1.0;
    public static final int DEFAULT_OUTPUT_AFTER = 32;
    public static final String VERSION_1_0 = "1.0";
    @JsonPropertyDescription(value="The algorithm version number. Default is 1.0.")
    @JsonProperty(value="version", defaultValue="1.0")
    private String version = "1.0";
    public static final Set<String> validVersions = new HashSet<String>(Set.of("1.0"));
    @JsonPropertyDescription(value="The type of data sent to the algorithm. Default is metrics type")
    @JsonProperty(value="type", defaultValue="metrics")
    private String type = RandomCutForestType.METRICS.toString();
    public static final Set<String> validTypes = new HashSet<String>(Set.of(RandomCutForestType.METRICS.toString()));
    @JsonPropertyDescription(value="The shingle size used in the ML algorithm. Default is 4.")
    @JsonProperty(value="shingle_size", defaultValue="4")
    private int shingleSize = 4;
    @JsonPropertyDescription(value="The sample size used in the ML algorithm. Default is 256.")
    @JsonProperty(value="sample_size", defaultValue="256")
    private int sampleSize = 256;
    @JsonPropertyDescription(value="The time decay value used in the ML algorithm. Used as the mathematical expression timeDecay divided by SampleSize in the ML algorithm. Default is 0.1")
    @JsonProperty(value="time_decay", defaultValue="0.1")
    private double timeDecay = 0.1;
    @JsonPropertyDescription(value="The number of events to train the model before generating an anomaly event. Default is 32.")
    @JsonProperty(value="output_after", defaultValue="32")
    private int outputAfter = 32;

    @AssertTrue(message="Value of output_after must be less than or equal to the value of sample_size")
    public @AssertTrue(message="Value of output_after must be less than or equal to the value of sample_size") boolean outputAfterCheck() {
        return this.outputAfter <= this.sampleSize;
    }

    public int getOutputAfter() {
        if (!this.outputAfterCheck()) {
            throw new IllegalArgumentException(String.format("outputAfter value of %d is not valid, It should be smaller than sample size, which is set to %d", this.outputAfter, this.sampleSize));
        }
        return this.outputAfter;
    }

    public int getShingleSize() {
        if (this.shingleSize < 1 || this.shingleSize > 60) {
            throw new IllegalArgumentException(String.format("Shingle size of %d is not valid, valid range is %d - %d", this.shingleSize, 1, 60));
        }
        return this.shingleSize;
    }

    public int getSampleSize() {
        if (this.sampleSize < 100 || this.sampleSize > 2500) {
            throw new IllegalArgumentException(String.format("Sample size of %d is not valid, valid range is %d - %d", this.sampleSize, 100, 2500));
        }
        return this.sampleSize;
    }

    public double getTimeDecay() {
        if (this.timeDecay < 0.0 || this.timeDecay > 1.0) {
            throw new IllegalArgumentException(String.format("Time Decay of %f is not valid, valid range is %f - %f", this.timeDecay, 0.0, 1.0));
        }
        return this.timeDecay;
    }

    public String getType() {
        if (!validTypes.contains(this.type)) {
            throw new IllegalArgumentException("Unknown type " + this.type);
        }
        return this.type;
    }

    public String getVersion() {
        if (!validVersions.contains(this.version)) {
            throw new IllegalArgumentException("Unknown version " + this.version);
        }
        return this.version;
    }
}

