/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.request;

import java.net.InetAddress;
import java.util.EnumSet;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.type.Asn1Encodeable;
import org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.ap.ApOption;
import org.apache.kerby.kerberos.kerb.type.ap.ApOptions;
import org.apache.kerby.kerberos.kerb.type.ap.ApReq;
import org.apache.kerby.kerberos.kerb.type.ap.Authenticator;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.HostAddresses;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.ticket.EncTicketPart;
import org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.Ticket;

public class ApRequest {
    private PrincipalName clientPrincipal;
    private SgtTicket sgtTicket;
    private ApReq apReq;
    private EnumSet<ApOption> flags;

    public ApRequest(PrincipalName clientPrincipal, SgtTicket sgtTicket) {
        this(clientPrincipal, sgtTicket, EnumSet.of(ApOption.USE_SESSION_KEY));
    }

    public ApRequest(PrincipalName clientPrincipal, SgtTicket sgtTicket, EnumSet<ApOption> flags) {
        this.clientPrincipal = clientPrincipal;
        this.sgtTicket = sgtTicket;
        this.flags = flags;
    }

    public ApReq getApReq() throws KrbException {
        if (this.apReq == null) {
            this.apReq = this.makeApReq();
        }
        return this.apReq;
    }

    public void setApReq(ApReq apReq) {
        this.apReq = apReq;
    }

    private ApReq makeApReq() throws KrbException {
        ApReq apReq = new ApReq();
        Authenticator authenticator = this.makeAuthenticator();
        EncryptionKey sessionKey = this.sgtTicket.getSessionKey();
        EncryptedData authData = EncryptionUtil.seal((Asn1Encodeable)authenticator, sessionKey, KeyUsage.AP_REQ_AUTH);
        apReq.setEncryptedAuthenticator(authData);
        apReq.setAuthenticator(authenticator);
        apReq.setTicket(this.sgtTicket.getTicket());
        ApOptions apOptions = new ApOptions();
        for (ApOption flag : this.flags) {
            apOptions.setFlag((EnumType)flag);
        }
        apReq.setApOptions(apOptions);
        return apReq;
    }

    private Authenticator makeAuthenticator() throws KrbException {
        Authenticator authenticator = new Authenticator();
        authenticator.setAuthenticatorVno(5);
        authenticator.setCname(this.clientPrincipal);
        authenticator.setCrealm(this.sgtTicket.getRealm());
        long millis = System.currentTimeMillis();
        int usec = (int)(millis % 1000L) * 1000;
        millis -= millis % 1000L;
        authenticator.setCtime(new KerberosTime(millis));
        authenticator.setCusec(usec);
        if (this.flags.contains(ApOption.USE_SESSION_KEY)) {
            authenticator.setSubKey(this.sgtTicket.getSessionKey());
        }
        return authenticator;
    }

    public static void validate(EncryptionKey encKey, ApReq apReq) throws KrbException {
        Ticket ticket = apReq.getTicket();
        if (encKey == null) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_NOKEY);
        }
        EncTicketPart encPart = EncryptionUtil.unseal(ticket.getEncryptedEncPart(), encKey, KeyUsage.KDC_REP_TICKET, EncTicketPart.class);
        ticket.setEncPart(encPart);
        ApRequest.unsealAuthenticator(encPart.getKey(), apReq);
        Authenticator authenticator = apReq.getAuthenticator();
        if (!authenticator.getCname().equals((Object)ticket.getEncPart().getCname())) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_BADMATCH);
        }
        if (!authenticator.getCrealm().equals(ticket.getEncPart().getCrealm())) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_BADMATCH);
        }
    }

    public static void validate(EncryptionKey encKey, ApReq apReq, InetAddress initiator, long timeSkew) throws KrbException {
        HostAddresses clientAddrs;
        ApRequest.validate(encKey, apReq);
        Ticket ticket = apReq.getTicket();
        EncTicketPart tktEncPart = ticket.getEncPart();
        Authenticator authenticator = apReq.getAuthenticator();
        if (initiator != null && (clientAddrs = tktEncPart.getClientAddresses()) != null && !clientAddrs.contains(initiator)) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_BADADDR);
        }
        if (timeSkew != 0L) {
            if (!authenticator.getCtime().isInClockSkew(timeSkew)) {
                throw new KrbException(KrbErrorCode.KRB_AP_ERR_SKEW);
            }
            KerberosTime now = KerberosTime.now();
            KerberosTime startTime = tktEncPart.getStartTime();
            if (startTime != null && !startTime.lessThanWithSkew(now, timeSkew)) {
                throw new KrbException(KrbErrorCode.KRB_AP_ERR_TKT_NYV);
            }
            if (tktEncPart.getEndTime().lessThanWithSkew(now, timeSkew)) {
                throw new KrbException(KrbErrorCode.KRB_AP_ERR_TKT_EXPIRED);
            }
        }
    }

    public static void unsealAuthenticator(EncryptionKey encKey, ApReq apReq) throws KrbException {
        EncryptedData authData = apReq.getEncryptedAuthenticator();
        Authenticator authenticator = EncryptionUtil.unseal(authData, encKey, KeyUsage.AP_REQ_AUTH, Authenticator.class);
        apReq.setAuthenticator(authenticator);
    }
}

