/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logging;

import java.util.Arrays;
import java.util.Set;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.message.Message;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.slf4j.helpers.MessageFormatter;

@Plugin(name="sensitiveArgumentMaskingConverter", category="Converter")
@ConverterKeys(value={"mask"})
public class SensitiveArgumentMaskingConverter
extends LogEventPatternConverter {
    static final Set<String> SENSITIVE_MARKER_NAMES = Set.of(DataPrepperMarkers.EVENT.getName(), DataPrepperMarkers.SENSITIVE.getName());
    static final String MASK_PATTERN = "******";

    public static SensitiveArgumentMaskingConverter newInstance() {
        return new SensitiveArgumentMaskingConverter("sensitiveArgument", null);
    }

    protected SensitiveArgumentMaskingConverter(String name, String style) {
        super(name, style);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        Marker marker = event.getMarker();
        Message message = event.getMessage();
        if (marker != null && SENSITIVE_MARKER_NAMES.contains(marker.getName())) {
            Object[] maskPatternArguments = new Object[message.getParameters().length];
            Arrays.fill(maskPatternArguments, MASK_PATTERN);
            toAppendTo.append(MessageFormatter.arrayFormat((String)message.getFormat(), (Object[])maskPatternArguments).getMessage());
        } else {
            toAppendTo.append(message.getFormattedMessage());
        }
    }
}

