/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.router;

import java.util.Objects;
import java.util.Set;
import org.opensearch.dataprepper.core.pipeline.router.DataFlowComponentRouter;
import org.opensearch.dataprepper.core.pipeline.router.RouteEventEvaluator;
import org.opensearch.dataprepper.core.pipeline.router.Router;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.model.configuration.ConditionalRoute;

public class RouterFactory {
    private final ExpressionEvaluator expressionEvaluator;
    private final DataFlowComponentRouter dataFlowComponentRouter;

    RouterFactory(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = Objects.requireNonNull(expressionEvaluator);
        this.dataFlowComponentRouter = new DataFlowComponentRouter();
    }

    public Router createRouter(Set<ConditionalRoute> routes) {
        RouteEventEvaluator routeEventEvaluator = new RouteEventEvaluator(this.expressionEvaluator, routes);
        return new Router(routeEventEvaluator, this.dataFlowComponentRouter, event -> event.getEventHandle().release(true));
    }
}

