/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.common;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.opensearch.dataprepper.core.pipeline.common.FutureHelperResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FutureHelper {
    private static final Logger LOG = LoggerFactory.getLogger(FutureHelper.class);

    public static <A> FutureHelperResult<A> awaitFuturesIndefinitely(List<Future<A>> futureList) {
        ArrayList completedFutureResults = new ArrayList(futureList.size());
        ArrayList<ExecutionException> failedExceptionList = new ArrayList<ExecutionException>();
        LinkedList<Future<A>> futureQueue = new LinkedList<Future<A>>(futureList);
        while (!futureQueue.isEmpty()) {
            Future future = (Future)futureQueue.remove();
            try {
                completedFutureResults.add(future.get());
            }
            catch (ExecutionException e) {
                failedExceptionList.add(e);
                LOG.error("FutureTask failed due to: ", (Throwable)e);
            }
            catch (InterruptedException e) {
                LOG.error("FutureTask is interrupted or timed out");
            }
        }
        return new FutureHelperResult(completedFutureResults, failedExceptionList);
    }
}

