/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.buffer;

import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.Counter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.opensearch.dataprepper.core.pipeline.PipelineRunner;
import org.opensearch.dataprepper.core.pipeline.SupportsPipelineRunner;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.CheckpointState;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="zero", pluginType=Buffer.class)
public class ZeroBuffer<T extends Record<?>>
implements Buffer<T>,
SupportsPipelineRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ZeroBuffer.class);
    private static final String PLUGIN_COMPONENT_ID = "ZeroBuffer";
    static final CheckpointState EMPTY_CHECKPOINT = new CheckpointState(0);
    static final int DEFAULT_READ_SLEEP_MILLIS = 1000;
    private final PluginMetrics pluginMetrics;
    private final ThreadLocal<Collection<T>> threadLocalStore;
    private PipelineRunner pipelineRunner;
    @VisibleForTesting
    final String pipelineName;
    private final Counter writeRecordsCounter;
    private final Counter readRecordsCounter;

    @DataPrepperPluginConstructor
    public ZeroBuffer(PipelineDescription pipelineDescription) {
        this.pluginMetrics = PluginMetrics.fromNames((String)PLUGIN_COMPONENT_ID, (String)pipelineDescription.getPipelineName());
        this.pipelineName = pipelineDescription.getPipelineName();
        this.threadLocalStore = new ThreadLocal();
        this.writeRecordsCounter = this.pluginMetrics.counter("recordsWritten");
        this.readRecordsCounter = this.pluginMetrics.counter("recordsRead");
    }

    public void write(T record, int timeoutInMillis) throws TimeoutException {
        if (record == null) {
            throw new NullPointerException("The write record cannot be null");
        }
        if (this.threadLocalStore.get() == null) {
            this.threadLocalStore.set(new ArrayList());
        }
        this.threadLocalStore.get().add(record);
        this.writeRecordsCounter.increment();
        this.getPipelineRunner().runAllProcessorsAndPublishToSinks();
    }

    public void writeAll(Collection<T> records, int timeoutInMillis) throws Exception {
        if (records == null) {
            throw new NullPointerException("The write records cannot be null");
        }
        if (this.threadLocalStore.get() == null) {
            this.threadLocalStore.set(new ArrayList<T>(records));
        } else {
            this.threadLocalStore.get().addAll(records);
        }
        this.writeRecordsCounter.increment((double)records.size());
        this.getPipelineRunner().runAllProcessorsAndPublishToSinks();
    }

    public Map.Entry<Collection<T>, CheckpointState> read(int timeoutInMillis) {
        if (this.threadLocalStore.get() == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.debug("Thread interrupted while waiting for data in empty buffer, returning empty result");
            }
            return Map.entry(Collections.emptySet(), EMPTY_CHECKPOINT);
        }
        Collection<T> storedRecords = this.threadLocalStore.get();
        CheckpointState checkpointState = EMPTY_CHECKPOINT;
        if (storedRecords != null && !storedRecords.isEmpty()) {
            checkpointState = new CheckpointState(storedRecords.size());
            this.threadLocalStore.remove();
            this.readRecordsCounter.increment((double)storedRecords.size());
        }
        return Map.entry(storedRecords, checkpointState);
    }

    public void checkpoint(CheckpointState checkpointState) {
    }

    public boolean isEmpty() {
        return this.threadLocalStore.get() == null || this.threadLocalStore.get().isEmpty();
    }

    @Override
    public PipelineRunner getPipelineRunner() {
        return this.pipelineRunner;
    }

    @Override
    public void setPipelineRunner(PipelineRunner pipelineRunner) {
        this.pipelineRunner = pipelineRunner;
    }
}

