/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.parser.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.micrometer.cloudwatch2.CloudWatchMeterRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.opensearch.dataprepper.core.meter.EMFLoggingMeterRegistry;
import org.opensearch.dataprepper.core.meter.EMFLoggingRegistryConfig;
import org.opensearch.dataprepper.core.meter.JvmMemoryAggregateMetrics;
import org.opensearch.dataprepper.core.parser.config.CustomTagsMeterFilter;
import org.opensearch.dataprepper.core.parser.config.DisableMetricsFilter;
import org.opensearch.dataprepper.core.parser.config.MetricTagFilter;
import org.opensearch.dataprepper.core.parser.model.DataPrepperConfiguration;
import org.opensearch.dataprepper.core.parser.model.MetricRegistryType;
import org.opensearch.dataprepper.core.pipeline.server.CloudWatchMeterRegistryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.core.exception.SdkClientException;

@Configuration
public class MetricsConfig {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsConfig.class);
    private static final String METRICS_CONTEXT_PREFIX = "/metrics";

    @Bean
    public YAMLFactory yamlFactory() {
        return new YAMLFactory();
    }

    @Bean
    public ObjectMapper objectMapper(YAMLFactory yamlFactory) {
        return new ObjectMapper((JsonFactory)yamlFactory);
    }

    @Bean
    public ClassLoaderMetrics classLoaderMetrics() {
        return new ClassLoaderMetrics();
    }

    @Bean
    public JvmMemoryMetrics jvmMemoryMetrics() {
        return new JvmMemoryMetrics();
    }

    @Bean
    public JvmGcMetrics jvmGcMetrics() {
        return new JvmGcMetrics();
    }

    @Bean
    public ProcessorMetrics processorMetrics() {
        return new ProcessorMetrics();
    }

    @Bean
    public JvmThreadMetrics jvmThreadMetrics() {
        return new JvmThreadMetrics();
    }

    @Bean
    public JvmMemoryAggregateMetrics jvmMemoryAggregateMetrics() {
        return new JvmMemoryAggregateMetrics();
    }

    private void configureMetricRegistry(Map<String, String> metricTags, List<MetricTagFilter> metricTagFilters, List<String> disabledMetrics, MeterRegistry meterRegistry) {
        meterRegistry.config().meterFilter((MeterFilter)new DisableMetricsFilter(disabledMetrics));
        meterRegistry.config().meterFilter((MeterFilter)new CustomTagsMeterFilter(metricTags, metricTagFilters));
    }

    @Bean
    public PrometheusMeterRegistry prometheusMeterRegistry(DataPrepperConfiguration dataPrepperConfiguration) {
        if (dataPrepperConfiguration.getMetricRegistryTypes().contains((Object)MetricRegistryType.Prometheus)) {
            PrometheusMeterRegistry meterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
            this.configureMetricRegistry(dataPrepperConfiguration.getMetricTags(), dataPrepperConfiguration.getMetricTagFilters(), dataPrepperConfiguration.getDisabledMetrics(), (MeterRegistry)meterRegistry);
            return meterRegistry;
        }
        return null;
    }

    @Bean
    public CloudWatchMeterRegistryProvider cloudWatchMeterRegistryProvider(DataPrepperConfiguration dataPrepperConfiguration) {
        if (dataPrepperConfiguration.getMetricRegistryTypes().contains((Object)MetricRegistryType.CloudWatch)) {
            return new CloudWatchMeterRegistryProvider();
        }
        return null;
    }

    @Bean
    public MeterRegistry cloudWatchMeterRegistry(DataPrepperConfiguration dataPrepperConfiguration, @Autowired(required=false) @Nullable CloudWatchMeterRegistryProvider cloudWatchMeterRegistryProvider) {
        if (dataPrepperConfiguration.getMetricRegistryTypes().contains((Object)MetricRegistryType.CloudWatch)) {
            if (cloudWatchMeterRegistryProvider == null) {
                throw new IllegalStateException("configuration required configure cloudwatch meter registry but one could not be configured");
            }
            try {
                CloudWatchMeterRegistry meterRegistry = cloudWatchMeterRegistryProvider.getCloudWatchMeterRegistry();
                this.configureMetricRegistry(dataPrepperConfiguration.getMetricTags(), dataPrepperConfiguration.getMetricTagFilters(), dataPrepperConfiguration.getDisabledMetrics(), (MeterRegistry)meterRegistry);
                return meterRegistry;
            }
            catch (SdkClientException e) {
                LOG.warn("Unable to configure Cloud Watch Meter Registry but Meter Registry was requested in Data Prepper Configuration");
                throw new RuntimeException("Unable to initialize Cloud Watch Meter Registry", e);
            }
        }
        return null;
    }

    @Bean
    public EMFLoggingMeterRegistry emfLoggingMeterRegistry(DataPrepperConfiguration dataPrepperConfiguration) {
        if (dataPrepperConfiguration.getMetricRegistryTypes().contains((Object)MetricRegistryType.EmbeddedMetricsFormat)) {
            EMFLoggingRegistryConfig config = this.createEMFLoggingRegistryConfig(dataPrepperConfiguration);
            EMFLoggingMeterRegistry meterRegistry = new EMFLoggingMeterRegistry(config);
            this.configureMetricRegistry(dataPrepperConfiguration.getMetricTags(), dataPrepperConfiguration.getMetricTagFilters(), dataPrepperConfiguration.getDisabledMetrics(), (MeterRegistry)meterRegistry);
            return meterRegistry;
        }
        return null;
    }

    @Bean
    public CompositeMeterRegistry systemMeterRegistry(List<MeterBinder> meterBinders, List<MeterRegistry> meterRegistries, DataPrepperConfiguration dataPrepperConfiguration) {
        CompositeMeterRegistry compositeMeterRegistry = new CompositeMeterRegistry();
        meterRegistries.forEach(meterRegistry -> {
            this.configureMetricRegistry(dataPrepperConfiguration.getMetricTags(), dataPrepperConfiguration.getMetricTagFilters(), dataPrepperConfiguration.getDisabledMetrics(), (MeterRegistry)meterRegistry);
            Metrics.addRegistry((MeterRegistry)meterRegistry);
            compositeMeterRegistry.add(meterRegistry);
        });
        meterBinders.forEach(binder -> binder.bindTo((MeterRegistry)compositeMeterRegistry));
        return compositeMeterRegistry;
    }

    private EMFLoggingRegistryConfig createEMFLoggingRegistryConfig(final DataPrepperConfiguration dataPrepperConfiguration) {
        return new EMFLoggingRegistryConfig(){

            public String get(String key) {
                return null;
            }

            @Override
            public Map<String, String> additionalProperties() {
                return Collections.unmodifiableMap(dataPrepperConfiguration.getEmfAdditionalProperties());
            }
        };
    }
}

