/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.breaker;

import java.util.List;
import java.util.Optional;
import org.opensearch.dataprepper.core.breaker.CircuitBreakerManager;
import org.opensearch.dataprepper.core.breaker.HeapCircuitBreaker;
import org.opensearch.dataprepper.core.breaker.InnerCircuitBreaker;
import org.opensearch.dataprepper.core.parser.model.CircuitBreakerConfig;
import org.opensearch.dataprepper.core.parser.model.DataPrepperConfiguration;
import org.opensearch.dataprepper.model.breaker.CircuitBreaker;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CircuitBreakerAppConfig {
    @Bean
    public CircuitBreakerManager circuitBreakerService(List<InnerCircuitBreaker> circuitBreakers) {
        return new CircuitBreakerManager(circuitBreakers);
    }

    @Bean
    InnerCircuitBreaker heapCircuitBreaker(DataPrepperConfiguration dataPrepperConfiguration) {
        CircuitBreakerConfig circuitBreakerConfig = dataPrepperConfiguration.getCircuitBreakerConfig();
        if (circuitBreakerConfig != null && circuitBreakerConfig.getHeapConfig() != null) {
            return new HeapCircuitBreaker(circuitBreakerConfig.getHeapConfig());
        }
        return null;
    }

    @Bean
    public Optional<CircuitBreaker> circuitBreaker(CircuitBreakerManager circuitBreakerManager) {
        return circuitBreakerManager.getGlobalCircuitBreaker();
    }
}

