/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.acknowledgements;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.opensearch.dataprepper.core.acknowledgements.DefaultAcknowledgementSet;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AcknowledgementSetMonitor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(AcknowledgementSetMonitor.class);
    private final Set<AcknowledgementSet> acknowledgementSets = new HashSet<AcknowledgementSet>();
    private final ReentrantLock lock = new ReentrantLock(true);
    private final AtomicInteger numInvalidAcquires = new AtomicInteger(0);
    private final AtomicInteger numInvalidReleases = new AtomicInteger(0);
    private final AtomicInteger numNullHandles = new AtomicInteger(0);

    public int getNumInvalidAcquires() {
        return this.numInvalidAcquires.get();
    }

    public int getNumInvalidReleases() {
        return this.numInvalidReleases.get();
    }

    public void add(AcknowledgementSet acknowledgementSet) {
        this.lock.lock();
        try {
            this.acknowledgementSets.add(acknowledgementSet);
        }
        finally {
            this.lock.unlock();
        }
    }

    int getSize() {
        return this.acknowledgementSets.size();
    }

    @Override
    public void run() {
        this.lock.lock();
        try {
            if (this.acknowledgementSets.size() > 0) {
                this.acknowledgementSets.removeIf(ackSet -> ((DefaultAcknowledgementSet)ackSet).isDone());
            }
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock.unlock();
        }
    }
}

