/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.Alert;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AlertReferenceRequest
extends BaseReferenceRequest<Alert> {
    public AlertReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Alert.class);
    }

    @Nonnull
    public AlertReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public AlertReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<Alert> putAsync(@Nonnull Alert srcAlert) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/security/alerts_v2/" + srcAlert.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public Alert put(@Nonnull Alert srcAlert) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/security/alerts_v2/" + srcAlert.id));
        return (Alert)this.send(HttpMethod.PUT, payload);
    }
}

