/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.RecordOperation;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecordOperationRequest
extends BaseRequest<RecordOperation> {
    public RecordOperationRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RecordOperation.class);
    }

    @Nonnull
    public CompletableFuture<RecordOperation> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public RecordOperation get() throws ClientException {
        return (RecordOperation)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<RecordOperation> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public RecordOperation delete() throws ClientException {
        return (RecordOperation)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<RecordOperation> patchAsync(@Nonnull RecordOperation sourceRecordOperation) {
        return this.sendAsync(HttpMethod.PATCH, sourceRecordOperation);
    }

    @Nullable
    public RecordOperation patch(@Nonnull RecordOperation sourceRecordOperation) throws ClientException {
        return (RecordOperation)this.send(HttpMethod.PATCH, sourceRecordOperation);
    }

    @Nonnull
    public CompletableFuture<RecordOperation> postAsync(@Nonnull RecordOperation newRecordOperation) {
        return this.sendAsync(HttpMethod.POST, newRecordOperation);
    }

    @Nullable
    public RecordOperation post(@Nonnull RecordOperation newRecordOperation) throws ClientException {
        return (RecordOperation)this.send(HttpMethod.POST, newRecordOperation);
    }

    @Nonnull
    public CompletableFuture<RecordOperation> putAsync(@Nonnull RecordOperation newRecordOperation) {
        return this.sendAsync(HttpMethod.PUT, newRecordOperation);
    }

    @Nullable
    public RecordOperation put(@Nonnull RecordOperation newRecordOperation) throws ClientException {
        return (RecordOperation)this.send(HttpMethod.PUT, newRecordOperation);
    }

    @Nonnull
    public RecordOperationRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public RecordOperationRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

