/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.ChecklistItem;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChecklistItemRequest
extends BaseRequest<ChecklistItem> {
    public ChecklistItemRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChecklistItem.class);
    }

    @Nonnull
    public CompletableFuture<ChecklistItem> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public ChecklistItem get() throws ClientException {
        return (ChecklistItem)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<ChecklistItem> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public ChecklistItem delete() throws ClientException {
        return (ChecklistItem)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<ChecklistItem> patchAsync(@Nonnull ChecklistItem sourceChecklistItem) {
        return this.sendAsync(HttpMethod.PATCH, sourceChecklistItem);
    }

    @Nullable
    public ChecklistItem patch(@Nonnull ChecklistItem sourceChecklistItem) throws ClientException {
        return (ChecklistItem)this.send(HttpMethod.PATCH, sourceChecklistItem);
    }

    @Nonnull
    public CompletableFuture<ChecklistItem> postAsync(@Nonnull ChecklistItem newChecklistItem) {
        return this.sendAsync(HttpMethod.POST, newChecklistItem);
    }

    @Nullable
    public ChecklistItem post(@Nonnull ChecklistItem newChecklistItem) throws ClientException {
        return (ChecklistItem)this.send(HttpMethod.POST, newChecklistItem);
    }

    @Nonnull
    public CompletableFuture<ChecklistItem> putAsync(@Nonnull ChecklistItem newChecklistItem) {
        return this.sendAsync(HttpMethod.PUT, newChecklistItem);
    }

    @Nullable
    public ChecklistItem put(@Nonnull ChecklistItem newChecklistItem) throws ClientException {
        return (ChecklistItem)this.send(HttpMethod.PUT, newChecklistItem);
    }

    @Nonnull
    public ChecklistItemRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ChecklistItemRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

