/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.BookingService;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BookingServiceRequest
extends BaseRequest<BookingService> {
    public BookingServiceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BookingService.class);
    }

    @Nonnull
    public CompletableFuture<BookingService> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public BookingService get() throws ClientException {
        return (BookingService)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<BookingService> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public BookingService delete() throws ClientException {
        return (BookingService)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<BookingService> patchAsync(@Nonnull BookingService sourceBookingService) {
        return this.sendAsync(HttpMethod.PATCH, sourceBookingService);
    }

    @Nullable
    public BookingService patch(@Nonnull BookingService sourceBookingService) throws ClientException {
        return (BookingService)this.send(HttpMethod.PATCH, sourceBookingService);
    }

    @Nonnull
    public CompletableFuture<BookingService> postAsync(@Nonnull BookingService newBookingService) {
        return this.sendAsync(HttpMethod.POST, newBookingService);
    }

    @Nullable
    public BookingService post(@Nonnull BookingService newBookingService) throws ClientException {
        return (BookingService)this.send(HttpMethod.POST, newBookingService);
    }

    @Nonnull
    public CompletableFuture<BookingService> putAsync(@Nonnull BookingService newBookingService) {
        return this.sendAsync(HttpMethod.PUT, newBookingService);
    }

    @Nullable
    public BookingService put(@Nonnull BookingService newBookingService) throws ClientException {
        return (BookingService)this.send(HttpMethod.PUT, newBookingService);
    }

    @Nonnull
    public BookingServiceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public BookingServiceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

