/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.ml_inference.processor.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.Counter;
import java.util.List;
import java.util.Optional;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.failures.DlqObject;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.ml_inference.processor.MLProcessor;
import org.opensearch.dataprepper.plugins.ml_inference.processor.MLProcessorConfig;
import org.opensearch.dataprepper.plugins.ml_inference.processor.common.MLBatchJobCreator;
import org.opensearch.dataprepper.plugins.ml_inference.processor.dlq.DlqPushHandler;
import org.opensearch.dataprepper.plugins.ml_inference.processor.dlq.MLBatchJobFailedDlqData;
import org.opensearch.dataprepper.plugins.ml_inference.processor.util.MlCommonRequester;
import software.amazon.awssdk.auth.signer.Aws4Signer;

public abstract class AbstractBatchJobCreator
implements MLBatchJobCreator {
    public static final String NUMBER_OF_SUCCESSFUL_BATCH_JOBS_CREATION = "batchJobsCreationSucceeded";
    public static final String NUMBER_OF_FAILED_BATCH_JOBS_CREATION = "batchJobsCreationFailed";
    public static final String NUMBER_OF_RECORDS_FAILED_IN_BATCH_JOB = "recordsFailedInBatchJobCreation";
    public static final String NUMBER_OF_RECORDS_SUCCEEDED_IN_BATCH_JOB = "recordsSucceededInBatchJobCreation";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected static final int TOO_MANY_REQUESTS = 429;
    protected final MLProcessorConfig mlProcessorConfig;
    protected final AwsCredentialsSupplier awsCredentialsSupplier;
    protected final Counter numberOfBatchJobsSuccessCounter;
    protected final Counter numberOfBatchJobsFailedCounter;
    protected final Counter numberOfRecordsFailedCounter;
    protected final Counter numberOfRecordsSuccessCounter;
    protected final List<String> tagsOnFailure;
    protected final MlCommonRequester mlCommonRequester;
    protected DlqPushHandler dlqPushHandler = null;
    protected final long maxRetryTimeWindow;
    private static final Aws4Signer signer = Aws4Signer.create();

    public AbstractBatchJobCreator(MLProcessorConfig mlProcessorConfig, AwsCredentialsSupplier awsCredentialsSupplier, PluginMetrics pluginMetrics, DlqPushHandler dlqPushHandler) {
        this.mlProcessorConfig = mlProcessorConfig;
        this.awsCredentialsSupplier = awsCredentialsSupplier;
        this.numberOfBatchJobsSuccessCounter = pluginMetrics.counter(NUMBER_OF_SUCCESSFUL_BATCH_JOBS_CREATION);
        this.numberOfBatchJobsFailedCounter = pluginMetrics.counter(NUMBER_OF_FAILED_BATCH_JOBS_CREATION);
        this.numberOfRecordsFailedCounter = pluginMetrics.counter(NUMBER_OF_RECORDS_FAILED_IN_BATCH_JOB);
        this.numberOfRecordsSuccessCounter = pluginMetrics.counter(NUMBER_OF_RECORDS_SUCCEEDED_IN_BATCH_JOB);
        this.tagsOnFailure = mlProcessorConfig.getTagsOnFailure();
        this.mlCommonRequester = new MlCommonRequester(signer, mlProcessorConfig, awsCredentialsSupplier);
        this.dlqPushHandler = dlqPushHandler;
        this.maxRetryTimeWindow = mlProcessorConfig.getRetryTimeWindow().toMillis();
    }

    public void incrementSuccessCounter() {
        this.numberOfBatchJobsSuccessCounter.increment();
    }

    public void incrementFailureCounter() {
        this.numberOfBatchJobsFailedCounter.increment();
    }

    @Override
    public abstract void createMLBatchJob(List<Record<Event>> var1, List<Record<Event>> var2);

    protected List<Record<Event>> addFailureTags(List<Record<Event>> records) {
        if (this.tagsOnFailure == null || this.tagsOnFailure.isEmpty()) {
            return records;
        }
        for (Record<Event> record : records) {
            Event event = (Event)record.getData();
            EventMetadata metadata = event.getMetadata();
            if (metadata != null) {
                metadata.addTags(this.tagsOnFailure);
                continue;
            }
            MLProcessor.LOG.warn("Event metadata is null, cannot add failure tags.");
        }
        return records;
    }

    protected DlqObject createDlqObjectFromEvent(Event event, int status, String message) {
        String bucket = Optional.ofNullable(event.getJsonNode().get("bucket")).map(JsonNode::asText).orElse("");
        String key = Optional.ofNullable(event.getJsonNode().get("key")).map(JsonNode::asText).orElse("");
        return DlqObject.builder().withEventHandle(event.getEventHandle()).withFailedData((Object)MLBatchJobFailedDlqData.builder().withS3Bucket(bucket).withS3Key(key).withData(event.toJsonString()).withStatus(status).withMessage(message).build()).withPluginName(this.dlqPushHandler.getDlqPluginSetting().getName()).withPipelineName(this.dlqPushHandler.getDlqPluginSetting().getPipelineName()).withPluginId(this.dlqPushHandler.getDlqPluginSetting().getName()).build();
    }

    class RetryRecord {
        private final Record<Event> record;
        private final long createdTime;
        private int retryCount;

        RetryRecord(Record<Event> record) {
            this.record = record;
            this.createdTime = System.currentTimeMillis();
            this.retryCount = 0;
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.createdTime > AbstractBatchJobCreator.this.maxRetryTimeWindow;
        }

        void incrementRetryCount() {
            ++this.retryCount;
        }

        Record<Event> getRecord() {
            return this.record;
        }

        int getRetryCount() {
            return this.retryCount;
        }
    }
}

