/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper;

import com.google.protobuf.Duration;
import com.google.rpc.RetryInfo;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;

public class RetryInfoCalculator {
    private final java.time.Duration minimumDelay;
    private final java.time.Duration maximumDelay;
    private final AtomicReference<Instant> lastTimeCalled;
    private final AtomicReference<java.time.Duration> nextDelay;

    public RetryInfoCalculator(java.time.Duration minimumDelay, java.time.Duration maximumDelay) {
        this.minimumDelay = minimumDelay;
        this.maximumDelay = maximumDelay;
        this.lastTimeCalled = new AtomicReference<Instant>(Instant.now().minus(maximumDelay));
        this.nextDelay = new AtomicReference<java.time.Duration>(minimumDelay);
    }

    private static RetryInfo createProtoResult(java.time.Duration delay) {
        return RetryInfo.newBuilder().setRetryDelay(RetryInfoCalculator.mapDuration(delay)).build();
    }

    private static java.time.Duration minDuration(java.time.Duration left, java.time.Duration right) {
        return left.compareTo(right) <= 0 ? left : right;
    }

    private static Duration.Builder mapDuration(java.time.Duration duration) {
        return Duration.newBuilder().setSeconds(duration.getSeconds()).setNanos(duration.getNano());
    }

    public RetryInfo createRetryInfo() {
        Instant now = Instant.now();
        if (this.lastTimeCalled.getAndSet(now).isBefore(now.minus(this.nextDelay.get()))) {
            this.nextDelay.set(this.minimumDelay);
            return RetryInfoCalculator.createProtoResult(this.minimumDelay);
        }
        java.time.Duration delay = this.nextDelay.getAndUpdate(d -> RetryInfoCalculator.minDuration(this.maximumDelay, d.multipliedBy(2L)));
        return RetryInfoCalculator.createProtoResult(delay);
    }
}

