/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.pipeline.parser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyConfiguration;
import org.opensearch.dataprepper.model.event.EventKeyFactory;

public class EventKeyDeserializer
extends StdDeserializer<EventKey>
implements ContextualDeserializer {
    private final EventKeyFactory eventKeyFactory;
    private final EventKeyFactory.EventAction[] eventAction;

    public EventKeyDeserializer(EventKeyFactory eventKeyFactory) {
        this(eventKeyFactory, new EventKeyFactory.EventAction[]{EventKeyFactory.EventAction.ALL});
    }

    private EventKeyDeserializer(EventKeyFactory eventKeyFactory, EventKeyFactory.EventAction[] eventAction) {
        super(EventKey.class);
        this.eventKeyFactory = eventKeyFactory;
        this.eventAction = eventAction;
    }

    public EventKey deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        String eventKeyString = parser.getValueAsString();
        return this.eventKeyFactory.createEventKey(eventKeyString, this.eventAction);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty property) {
        if (property == null) {
            return this;
        }
        EventKeyConfiguration eventKeyConfiguration = (EventKeyConfiguration)property.getAnnotation(EventKeyConfiguration.class);
        if (eventKeyConfiguration == null) {
            return this;
        }
        EventKeyFactory.EventAction[] eventAction = eventKeyConfiguration.value();
        return new EventKeyDeserializer(this.eventKeyFactory, eventAction);
    }
}

