/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.annotations.ConditionalRequired;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.model.event.EventKey;
import org.opensearch.dataprepper.model.event.EventKeyConfiguration;
import org.opensearch.dataprepper.model.event.EventKeyFactory;

@ConditionalRequired(value={@ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="entries", value="null"), @ConditionalRequired.SchemaProperty(field="with_keys_regex", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="with_keys")}), @ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="entries", value="null"), @ConditionalRequired.SchemaProperty(field="with_keys", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="with_keys_regex")}), @ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="with_keys", value="null"), @ConditionalRequired.SchemaProperty(field="with_keys_regex", value="null")}, thenExpect={@ConditionalRequired.SchemaProperty(field="entries")})})
@JsonPropertyOrder
@JsonClassDescription(value="The <code>delete_entries</code> processor deletes fields from events. You can specify the keys of the fields you want to delete using the <code>with_keys</code> or <code>with_keys_regex</code> configuration options. You can only use one per entry. Those keys and their values are deleted from the events.")
public class DeleteEntryProcessorConfig {
    @JsonProperty(value="with_keys")
    @EventKeyConfiguration(value={EventKeyFactory.EventAction.DELETE})
    @JsonPropertyDescription(value="A list of keys to be deleted. May not be used with entries.")
    private List<@NotNull @NotEmpty EventKey> withKeys;
    @JsonProperty(value="with_keys_regex")
    @JsonPropertyDescription(value="A list of regex patterns that match keys to be deleted from an event. May not be used with entries.")
    private List<String> withKeysRegex;
    @JsonProperty(value="exclude_from_delete")
    @JsonPropertyDescription(value="A list of keys to exclude from deletion when using with_keys_regex.")
    private Set<EventKey> excludeFromDelete;
    @JsonProperty(value="delete_when")
    @JsonPropertyDescription(value="Specifies under what condition the deletion should be performed.")
    private String deleteWhen;
    @Valid
    @JsonProperty(value="entries")
    @JsonPropertyDescription(value="A list of entries to delete from the event.")
    private List<Entry> entries;
    @JsonIgnore
    private List<Pattern> withKeysRegexPatterns;
    @JsonPropertyDescription(value="Specifies the key of the list of object to iterate over and delete the keys specified in with_keys.")
    @JsonProperty(value="iterate_on")
    private String iterateOn;
    @JsonPropertyDescription(value="Specifies the condition for when to delete the key from each element of a list when using iterate_on.")
    @JsonProperty(value="delete_from_element_when")
    private String deleteFromElementWhen;

    @AssertTrue(message="One of the following must be provided: 'entries', 'with_keys', or 'with_keys_regex'. None of these are configured.")
    @AssertTrue(message="One of the following must be provided: 'entries', 'with_keys', or 'with_keys_regex'. None of these are configured.") boolean isConfigurationPresent() {
        return this.entries != null || this.withKeys != null || this.withKeysRegex != null;
    }

    @AssertTrue(message="You can only use one of the following at a time: 'entries', 'with_keys', or 'with_keys_regex'")
    @AssertTrue(message="You can only use one of the following at a time: 'entries', 'with_keys', or 'with_keys_regex'") boolean hasOnlyOneConfiguration() {
        int count = 0;
        if (this.entries != null) {
            ++count;
        }
        if (this.withKeys != null) {
            ++count;
        }
        if (this.withKeysRegex != null) {
            ++count;
        }
        return count == 1;
    }

    @AssertTrue(message="exclude_from_delete only applies when with_keys_regex is configured.")
    @AssertTrue(message="exclude_from_delete only applies when with_keys_regex is configured.") boolean isExcludeFromDeleteValid() {
        return this.excludeFromDelete == null || this.excludeFromDelete.isEmpty() || this.withKeysRegex != null && !this.withKeysRegex.isEmpty();
    }

    private void setWithKeysRegexPatterns() {
        this.withKeysRegexPatterns = this.getWithKeysRegex().stream().map(Pattern::compile).collect(Collectors.toList());
    }

    @AssertTrue(message="Invalid regex pattern in 'with_keys_regex'")
    @AssertTrue(message="Invalid regex pattern in 'with_keys_regex'") boolean isValidWithKeysRegexPattern() {
        if (this.withKeysRegex != null && !this.withKeysRegex.isEmpty()) {
            try {
                this.setWithKeysRegexPatterns();
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }
        return true;
    }

    public List<EventKey> getWithKeys() {
        return this.withKeys != null ? this.withKeys : Collections.emptyList();
    }

    public List<String> getWithKeysRegex() {
        return this.withKeysRegex != null ? this.withKeysRegex : Collections.emptyList();
    }

    public List<Pattern> getWithKeysRegexPattern() {
        if (this.withKeysRegexPatterns == null && this.withKeysRegex != null && !this.withKeysRegex.isEmpty()) {
            this.setWithKeysRegexPatterns();
        }
        return this.withKeysRegexPatterns != null ? this.withKeysRegexPatterns : Collections.emptyList();
    }

    public Set<EventKey> getExcludeFromDelete() {
        return this.excludeFromDelete != null ? this.excludeFromDelete : Collections.emptySet();
    }

    public String getDeleteWhen() {
        return this.deleteWhen;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public String getIterateOn() {
        return this.iterateOn;
    }

    public String getDeleteFromElementWhen() {
        return this.deleteFromElementWhen;
    }

    @JsonPropertyOrder
    public static class Entry {
        @JsonProperty(value="with_keys")
        @EventKeyConfiguration(value={EventKeyFactory.EventAction.DELETE})
        @JsonPropertyDescription(value="A list of keys to be deleted.")
        private List<@NotNull @NotEmpty EventKey> withKeys;
        @JsonProperty(value="with_keys_regex")
        @JsonPropertyDescription(value="A list of regex patterns to match keys to be deleted.")
        private List<String> withKeysRegex;
        @JsonProperty(value="exclude_from_delete")
        @JsonPropertyDescription(value="A list of keys to exclude from deletion when using with_keys_regex.")
        private Set<EventKey> excludeFromDelete;
        @JsonProperty(value="delete_when")
        @JsonPropertyDescription(value="Specifies under what condition the deletion should be performed. By default, keys are always deleted. Example: <code>/mykey == \"---\"</code>")
        @ExampleValues(value={@ExampleValues.Example(value="/some_key == null", description="Only runs the deletion if the key some_key is null or does not exist.")})
        private String deleteWhen;
        @JsonPropertyDescription(value="Specifies the condition for when to delete the key from each element of a list when using iterate_on.")
        @JsonProperty(value="delete_from_element_when")
        private String deleteFromElementWhen;
        @JsonPropertyDescription(value="Specifies the key of the list of object to iterate over and delete the keys specified in with_keys.")
        @JsonProperty(value="iterate_on")
        private String iterateOn;
        @JsonIgnore
        private List<Pattern> withKeysRegexPatterns;

        @AssertTrue(message="exclude_from_delete only applies when with_keys_regex is configured.")
        @AssertTrue(message="exclude_from_delete only applies when with_keys_regex is configured.") boolean isExcludeFromDeleteValid() {
            return this.excludeFromDelete == null || this.excludeFromDelete.isEmpty() || this.withKeysRegex != null && !this.withKeysRegex.isEmpty();
        }

        private void setWithKeysRegexPatterns() {
            this.withKeysRegexPatterns = this.getWithKeysRegex().stream().map(Pattern::compile).collect(Collectors.toList());
        }

        @AssertTrue(message="Invalid regex pattern found in with_keys_regex.")
        public @AssertTrue(message="Invalid regex pattern found in with_keys_regex.") boolean isValidWithKeysRegexPattern() {
            if (this.withKeysRegex != null && !this.withKeysRegex.isEmpty()) {
                try {
                    this.setWithKeysRegexPatterns();
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            }
            return true;
        }

        public List<EventKey> getWithKeys() {
            return this.withKeys != null ? this.withKeys : Collections.emptyList();
        }

        public List<String> getWithKeysRegex() {
            return this.withKeysRegex != null ? this.withKeysRegex : Collections.emptyList();
        }

        public List<Pattern> getWithKeysRegexPattern() {
            if (this.withKeysRegexPatterns == null && this.withKeysRegex != null && !this.withKeysRegex.isEmpty()) {
                this.setWithKeysRegexPatterns();
            }
            return this.withKeysRegexPatterns != null ? this.withKeysRegexPatterns : Collections.emptyList();
        }

        public Set<EventKey> getExcludeFromDelete() {
            return this.excludeFromDelete != null ? this.excludeFromDelete : Collections.emptySet();
        }

        public String getDeleteWhen() {
            return this.deleteWhen;
        }

        public String getIterateOn() {
            return this.iterateOn;
        }

        public String getDeleteFromElementWhen() {
            return this.deleteFromElementWhen;
        }

        public Entry(List<EventKey> withKeys, List<String> withKeysRegex, Set<EventKey> excludeFromDelete, String deleteWhen, String iterateOn, String deleteFromElementWhen) {
            this.withKeys = withKeys;
            this.withKeysRegex = withKeysRegex;
            this.excludeFromDelete = excludeFromDelete;
            this.deleteWhen = deleteWhen;
            this.deleteFromElementWhen = deleteFromElementWhen;
            this.iterateOn = iterateOn;
        }

        public Entry() {
        }
    }
}

