/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.AlsoRequired;
import org.opensearch.dataprepper.model.annotations.ExampleValues;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>copy_values</code> processor copies values from an event to another key in an event.")
public class CopyValueProcessorConfig {
    static final String FROM_LIST_KEY = "from_list";
    static final String TO_LIST_KEY = "to_list";
    @NotEmpty
    @NotNull
    @Valid
    @JsonPropertyDescription(value="A list of entries to be copied in an event.")
    private List<Entry> entries;
    @JsonProperty(value="from_list")
    @JsonPropertyDescription(value="The key of the list of objects to be copied. Both <code>from_key</code> and <code>to_key</code> must be configured and will be applied on the corresponding list.")
    @AlsoRequired(values={@AlsoRequired.Required(name="to_list")})
    private String fromList;
    @JsonProperty(value="to_list")
    @JsonPropertyDescription(value="The key of the new list to be added. Both <code>from_key</code> and <code>to_key</code> must be configured and will be applied on the corresponding list.")
    @AlsoRequired(values={@AlsoRequired.Required(name="from_list")})
    private String toList;
    @JsonProperty(value="overwrite_if_to_list_exists")
    @JsonPropertyDescription(value="When set to <code>true</code>, the existing value is overwritten if <code>key</code> already exists in the event. The default value is <code>false</code>.")
    private boolean overwriteIfToListExists = false;

    @AssertTrue(message="Both from_list and to_list should be specified when copying entries between lists.")
    @AssertTrue(message="Both from_list and to_list should be specified when copying entries between lists.") boolean isBothFromListAndToListProvided() {
        return this.fromList == null && this.toList == null || this.fromList != null && this.toList != null;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public String getFromList() {
        return this.fromList;
    }

    public String getToList() {
        return this.toList;
    }

    public boolean getOverwriteIfToListExists() {
        return this.overwriteIfToListExists;
    }

    @JsonPropertyOrder
    public static class Entry {
        @NotEmpty
        @NotNull
        @JsonProperty(value="from_key")
        @JsonPropertyDescription(value="The key of the entry to be copied. This must be configured.")
        private String fromKey;
        @NotEmpty
        @NotNull
        @JsonProperty(value="to_key")
        @JsonPropertyDescription(value="The key of the new entry to be added. This must be configured.")
        private String toKey;
        @JsonProperty(value="overwrite_if_to_key_exists")
        @JsonPropertyDescription(value="When set to <code>true</code>, the existing value is overwritten if <code>key</code> already exists in the event. The default value is <code>false</code>.")
        private boolean overwriteIfToKeyExists = false;
        @JsonProperty(value="copy_when")
        @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a>, such as <code>/some-key == \"test\"</code>, that will be evaluated to determine whether the processor will be run on the event.")
        @ExampleValues(value={@ExampleValues.Example(value="/some_key != null", description="Only runs the copy_values processor on the Event if the existing key some_key is not null."), @ExampleValues.Example(value="/some_key typeof integer", description="Only runs the copy_values processor on the Event if the key some_key is an integer.")})
        private String copyWhen;

        public String getFromKey() {
            return this.fromKey;
        }

        public String getToKey() {
            return this.toKey;
        }

        public boolean getOverwriteIfToKeyExists() {
            return this.overwriteIfToKeyExists;
        }

        public String getCopyWhen() {
            return this.copyWhen;
        }

        public Entry(String fromKey, String toKey, boolean overwriteIfToKeyExists, String copyWhen) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.overwriteIfToKeyExists = overwriteIfToKeyExists;
            this.copyWhen = copyWhen;
        }

        public Entry() {
        }
    }
}

