/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.common.sink;

import java.time.Instant;
import org.opensearch.dataprepper.common.sink.SinkBuffer;
import org.opensearch.dataprepper.common.sink.SinkBufferEntry;
import org.opensearch.dataprepper.common.sink.SinkBufferWriter;
import org.opensearch.dataprepper.common.sink.SinkFlushContext;
import org.opensearch.dataprepper.common.sink.SinkFlushableBuffer;

public class DefaultSinkBuffer
implements SinkBuffer {
    private final SinkBufferWriter sinkBufferWriter;
    private final long maxEvents;
    private final long maxRequestSize;
    private final long flushIntervalMs;
    private long lastFlushedTimeMs;
    private long numEvents;
    private long currentRequestSize;

    public DefaultSinkBuffer(long maxEvents, long maxRequestSize, long flushIntervalMs, SinkBufferWriter sinkBufferWriter) {
        this.maxEvents = maxEvents;
        this.maxRequestSize = maxRequestSize;
        this.flushIntervalMs = flushIntervalMs;
        this.sinkBufferWriter = sinkBufferWriter;
        this.lastFlushedTimeMs = Instant.now().toEpochMilli();
        this.numEvents = 0L;
        this.currentRequestSize = 0L;
    }

    @Override
    public boolean addToBuffer(SinkBufferEntry sinkBufferEntry) throws Exception {
        if (this.sinkBufferWriter.writeToBuffer(sinkBufferEntry)) {
            this.currentRequestSize += sinkBufferEntry.getEstimatedSize();
            ++this.numEvents;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMaxEventsLimitReached() {
        return this.numEvents >= this.maxEvents;
    }

    @Override
    public boolean exceedsFlushTimeInterval() {
        long curTime = System.currentTimeMillis();
        return curTime - this.lastFlushedTimeMs >= this.flushIntervalMs;
    }

    @Override
    public boolean willExceedMaxRequestSizeBytes(SinkBufferEntry sinkBufferEntry) {
        return this.currentRequestSize + sinkBufferEntry.getEstimatedSize() >= this.maxRequestSize;
    }

    @Override
    public SinkFlushableBuffer getFlushableBuffer(SinkFlushContext sinkFlushContext) {
        this.numEvents = 0L;
        this.currentRequestSize = 0L;
        this.lastFlushedTimeMs = System.currentTimeMillis();
        return this.sinkBufferWriter.getBuffer(sinkFlushContext);
    }
}

