/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.serialization;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.state.RandomCutForestMapper;
import com.amazon.randomcutforest.state.RandomCutForestState;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.util.Random;

public class ProtostuffExampleWithShingles
implements Example {
    public static void main(String[] args) throws Exception {
        new ProtostuffExampleWithShingles().run();
    }

    @Override
    public String command() {
        return "protostuffWithShingles";
    }

    @Override
    public String description() {
        return "serialize a Random Cut Forest with the protostuff library for shingled points";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        byte[] bytes;
        int dimensions = 10;
        int numberOfTrees = 50;
        int sampleSize = 256;
        Precision precision = Precision.FLOAT_64;
        RandomCutForest forest = RandomCutForest.builder().compact(true).dimensions(dimensions).numberOfTrees(numberOfTrees).sampleSize(sampleSize).precision(precision).shingleSize(dimensions).build();
        boolean count = true;
        int dataSize = 1000 * sampleSize;
        for (double[] point : this.generateShingledData(dataSize, dimensions, 0L)) {
            forest.update(point);
        }
        RandomCutForestMapper mapper = new RandomCutForestMapper();
        mapper.setSaveExecutorContextEnabled(true);
        mapper.setSaveTreeStateEnabled(false);
        Schema schema = RuntimeSchema.getSchema(RandomCutForestState.class);
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            RandomCutForestState state = mapper.toState(forest);
            bytes = ProtostuffIOUtil.toByteArray((Object)state, (Schema)schema, (LinkedBuffer)buffer);
        }
        finally {
            buffer.clear();
        }
        System.out.printf("dimensions = %d, numberOfTrees = %d, sampleSize = %d, precision = %s%n", dimensions, numberOfTrees, sampleSize, precision);
        System.out.printf("protostuff size = %d bytes%n", bytes.length);
        RandomCutForestState state2 = (RandomCutForestState)schema.newMessage();
        ProtostuffIOUtil.mergeFrom((byte[])bytes, (Object)state2, (Schema)schema);
        RandomCutForest forest2 = mapper.toModel(state2);
        int testSize = 10000;
        double delta = Math.log(sampleSize) / Math.log(2.0) * 0.05;
        int differences = 0;
        int anomalies = 0;
        for (double[] point : this.generateShingledData(testSize, dimensions, 2L)) {
            double score = forest.getAnomalyScore(point);
            double score2 = forest2.getAnomalyScore(point);
            if (score > 1.0 || score2 > 1.0) {
                ++anomalies;
                if (Math.abs(score - score2) > delta) {
                    ++differences;
                }
            }
            forest.update(point);
            forest2.update(point);
        }
        if ((double)differences >= 0.01 * (double)testSize) {
            throw new IllegalStateException("restored forest does not agree with original forest");
        }
        System.out.println("Looks good!");
    }

    private double[][] generateShingledData(int size, int dimensions, long seed) {
        double[][] answer = new double[size][];
        int entryIndex = 0;
        boolean filledShingleAtleastOnce = false;
        double[] history = new double[dimensions];
        int count = 0;
        double[] data = this.getDataD(size + dimensions - 1, 100.0, 5.0, seed);
        for (int j = 0; j < size + dimensions - 1; ++j) {
            history[entryIndex] = data[j];
            if ((entryIndex = (entryIndex + 1) % dimensions) == 0) {
                filledShingleAtleastOnce = true;
            }
            if (!filledShingleAtleastOnce) continue;
            answer[count++] = ProtostuffExampleWithShingles.getShinglePoint(history, entryIndex, dimensions);
        }
        return answer;
    }

    private static double[] getShinglePoint(double[] recentPointsSeen, int indexOfOldestPoint, int shingleLength) {
        double[] shingledPoint = new double[shingleLength];
        int i = 0;
        for (int j = 0; j < shingleLength; ++j) {
            double point = recentPointsSeen[(j + indexOfOldestPoint) % shingleLength];
            shingledPoint[i++] = point;
        }
        return shingledPoint;
    }

    double[] getDataD(int num, double amplitude, double noise, long seed) {
        double[] data = new double[num];
        Random noiseprg = new Random(seed);
        for (int i = 0; i < num; ++i) {
            data[i] = amplitude * Math.cos(Math.PI * 2 * (double)(i + 50) / 1000.0) + noise * noiseprg.nextDouble();
        }
        return data;
    }
}

