/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable;

import java.io.Serializable;
import java.util.Collection;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.impl.bag.mutable.UnmodifiableBag;
import org.eclipse.collections.impl.collection.mutable.AbstractSynchronizedMutableCollection;
import org.eclipse.collections.impl.collection.mutable.SynchronizedCollectionSerializationProxy;

public class SynchronizedBag<T>
extends AbstractSynchronizedMutableCollection<T>
implements MutableBag<T>,
Serializable {
    private static final long serialVersionUID = 2L;

    SynchronizedBag(MutableBag<T> bag) {
        super(bag);
    }

    public SynchronizedBag(MutableBag<T> bag, Object newLock) {
        super(bag, newLock);
    }

    public static <E, B extends MutableBag<E>> SynchronizedBag<E> of(B bag) {
        return new SynchronizedBag(bag);
    }

    public static <E, B extends MutableBag<E>> SynchronizedBag<E> of(B bag, Object lock) {
        return new SynchronizedBag(bag, lock);
    }

    @Override
    protected MutableBag<T> getDelegate() {
        return (MutableBag)super.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<T> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }

    protected Object writeReplace() {
        return new SynchronizedCollectionSerializationProxy<T>(this.getDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addOccurrences(T item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOccurrences(Object item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setOccurrences(T item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().setOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableMap<T, Integer> toMapOfItemToCount() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toMapOfItemToCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<T> selectByOccurrences(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectByOccurrences(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<ObjectIntPair<T>> topOccurrences(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().topOccurrences(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<ObjectIntPair<T>> bottomOccurrences(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().bottomOccurrences(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithOccurrences(ObjectIntProcedure<? super T> objectIntProcedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().forEachWithOccurrences(objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectWithOccurrences(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends Collection<V>> R collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getDelegate().collectWithOccurrences(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int occurrencesOf(Object item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringOfItemToCount() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toStringOfItemToCount();
        }
    }

    @Override
    public MutableBag<T> tap(Procedure<? super T> procedure) {
        return (MutableBag)super.tap(procedure);
    }

    @Override
    public MutableBag<T> select(Predicate<? super T> predicate) {
        return (MutableBag)super.select(predicate);
    }

    @Override
    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableBag)super.selectWith(predicate, parameter);
    }

    @Override
    public MutableBag<T> reject(Predicate<? super T> predicate) {
        return (MutableBag)super.reject(predicate);
    }

    @Override
    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableBag)super.rejectWith(predicate, parameter);
    }

    @Override
    public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
        return (PartitionMutableBag)super.partition(predicate);
    }

    @Override
    public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (PartitionMutableBag)super.partitionWith(predicate, parameter);
    }

    public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return (MutableBooleanBag)super.collectBoolean(booleanFunction);
    }

    public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
        return (MutableByteBag)super.collectByte(byteFunction);
    }

    public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
        return (MutableCharBag)super.collectChar(charFunction);
    }

    public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
        return (MutableDoubleBag)super.collectDouble(doubleFunction);
    }

    public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
        return (MutableFloatBag)super.collectFloat(floatFunction);
    }

    public MutableIntBag collectInt(IntFunction<? super T> intFunction) {
        return (MutableIntBag)super.collectInt(intFunction);
    }

    public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
        return (MutableLongBag)super.collectLong(longFunction);
    }

    public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
        return (MutableShortBag)super.collectShort(shortFunction);
    }

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        return (MutableBag)super.selectInstancesOf(clazz);
    }

    @Override
    public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
        return (MutableBag)super.collect(function);
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        return (MutableSet)super.zipWithIndex();
    }

    @Override
    public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return (MutableBag)super.collectWith(function, parameter);
    }

    @Override
    public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return (MutableBag)super.collectIf(predicate, function);
    }

    @Override
    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return (MutableBag)super.flatCollect(function);
    }

    @Override
    public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return (MutableBagMultimap)super.groupBy(function);
    }

    @Override
    public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return (MutableBagMultimap)super.groupByEach(function);
    }

    @Override
    @Deprecated
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
        return (MutableBag)super.zip(that);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<T> asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return UnmodifiableBag.of(this);
        }
    }

    public MutableBag<T> asSynchronized() {
        return this;
    }

    public ImmutableBag<T> toImmutable() {
        return Bags.immutable.withAll((Iterable)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<T> selectUnique() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectUnique();
        }
    }
}

