/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.opensearch;

import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.opensearch.dataprepper.model.plugin.PluginComponentRefresher;
import org.opensearch.dataprepper.plugins.source.opensearch.OpenSearchSourceConfiguration;
import org.opensearch.dataprepper.plugins.source.opensearch.metrics.OpenSearchSourcePluginMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRefresher<Client>
implements PluginComponentRefresher<Client, OpenSearchSourceConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(ClientRefresher.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final OpenSearchSourcePluginMetrics openSearchSourcePluginMetrics;
    private final Function<OpenSearchSourceConfiguration, Client> clientFunction;
    private OpenSearchSourceConfiguration existingConfig;
    private final Class<Client> clientClass;
    private Client currentClient;

    public ClientRefresher(OpenSearchSourcePluginMetrics openSearchSourcePluginMetrics, Class<Client> clientClass, Function<OpenSearchSourceConfiguration, Client> clientFunction, OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        this.openSearchSourcePluginMetrics = openSearchSourcePluginMetrics;
        this.clientClass = clientClass;
        this.clientFunction = clientFunction;
        this.existingConfig = openSearchSourceConfiguration;
        this.currentClient = clientFunction.apply(openSearchSourceConfiguration);
    }

    public Class<Client> getComponentClass() {
        return this.clientClass;
    }

    public Client get() {
        this.readWriteLock.readLock().lock();
        try {
            Client Client = this.currentClient;
            return Client;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void update(OpenSearchSourceConfiguration openSearchSourceConfiguration) {
        if (this.basicAuthChanged(openSearchSourceConfiguration)) {
            this.openSearchSourcePluginMetrics.getCredentialsChangeCounter().increment();
            this.readWriteLock.writeLock().lock();
            try {
                this.currentClient = this.clientFunction.apply(openSearchSourceConfiguration);
                this.existingConfig = openSearchSourceConfiguration;
            }
            catch (Exception e) {
                this.openSearchSourcePluginMetrics.getClientRefreshErrorsCounter().increment();
                LOG.error("Refreshing {} failed.", this.getComponentClass(), (Object)e);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    private boolean basicAuthChanged(OpenSearchSourceConfiguration newConfig) {
        String newPassword;
        String newUsername;
        String existingPassword;
        String existingUsername;
        if (this.existingConfig.getAuthConfig() != null) {
            existingUsername = this.existingConfig.getAuthConfig().getUsername();
            existingPassword = this.existingConfig.getAuthConfig().getPassword();
        } else {
            existingUsername = this.existingConfig.getUsername();
            existingPassword = this.existingConfig.getPassword();
        }
        if (newConfig.getAuthConfig() != null) {
            newUsername = newConfig.getAuthConfig().getUsername();
            newPassword = newConfig.getAuthConfig().getPassword();
        } else {
            newUsername = newConfig.getUsername();
            newPassword = newConfig.getPassword();
        }
        return !Objects.equals(existingUsername, newUsername) || !Objects.equals(existingPassword, newPassword);
    }
}

