/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.parse.ion;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.dataformat.ion.IonObjectMapper;
import io.micrometer.core.instrument.Counter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventKeyFactory;
import org.opensearch.dataprepper.model.event.HandleFailedEventsOption;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.plugins.processor.parse.AbstractParseProcessor;
import org.opensearch.dataprepper.plugins.processor.parse.ion.IonTimestampConverterModule;
import org.opensearch.dataprepper.plugins.processor.parse.ion.ParseIonProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="parse_ion", pluginType=Processor.class, pluginConfigurationType=ParseIonProcessorConfig.class)
public class ParseIonProcessor
extends AbstractParseProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ParseIonProcessor.class);
    private static final String PARSE_ERRORS = "parseErrors";
    private final IonObjectMapper objectMapper = new IonObjectMapper();
    private final Counter parseErrorsCounter;
    private final int depth;
    private final HandleFailedEventsOption handleFailedEventsOption;

    @DataPrepperPluginConstructor
    public ParseIonProcessor(PluginMetrics pluginMetrics, ParseIonProcessorConfig parseIonProcessorConfig, ExpressionEvaluator expressionEvaluator, EventKeyFactory eventKeyFactory) {
        super(pluginMetrics, parseIonProcessorConfig, expressionEvaluator, eventKeyFactory);
        this.depth = parseIonProcessorConfig.getDepth();
        this.objectMapper.registerModule((Module)new IonTimestampConverterModule());
        this.handleFailedEventsOption = parseIonProcessorConfig.getHandleFailedEventsOption();
        this.parseErrorsCounter = pluginMetrics.counter(PARSE_ERRORS);
    }

    @Override
    protected Optional<Map<String, Object>> readValue(String message, Event context) {
        try {
            HashMap map = (HashMap)this.objectMapper.convertValue(this.objectMapper.readValue(message, (TypeReference)new TypeReference<Object>(){}), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            if (this.depth == 0) {
                return Optional.of(map);
            }
            return Optional.of((Map)this.objectMapper.convertValue(this.convertNestedObjectToString(map, 1, this.depth), (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (JsonProcessingException e) {
            if (this.handleFailedEventsOption.shouldLog()) {
                LOG.error(DataPrepperMarkers.SENSITIVE, "An exception occurred due to invalid Ion while parsing [{}] due to {}", (Object)message, (Object)e.getMessage());
            }
            this.parseErrorsCounter.increment();
            return Optional.empty();
        }
        catch (Exception e) {
            if (this.handleFailedEventsOption.shouldLog()) {
                LOG.error(DataPrepperMarkers.SENSITIVE, "An exception occurred while using the parse_ion processor while parsing [{}]", (Object)message, (Object)e);
            }
            this.processingFailuresCounter.increment();
            return Optional.empty();
        }
    }
}

