/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum DataType {
    STRING("string"),
    BOOLEAN("boolean"),
    INTEGER("integer"),
    LONG("long"),
    DOUBLE("double"),
    BIG_DECIMAL("big_decimal"),
    MAP("map"),
    ARRAY("array");

    private static final Map<String, DataType> TYPES_MAP;
    private final String typeName;

    private DataType(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @JsonCreator
    public static DataType fromTypeName(String option) {
        return TYPES_MAP.get(option);
    }

    public static boolean isSameType(Object object, String option) {
        DataType type = DataType.fromTypeName(option);
        if (type == null) {
            throw new IllegalArgumentException("Unknown DataType");
        }
        switch (type) {
            case MAP: {
                return object instanceof Map;
            }
            case ARRAY: {
                return object instanceof ArrayList || object.getClass().isArray();
            }
            case DOUBLE: {
                return object instanceof Double;
            }
            case BOOLEAN: {
                return object instanceof Boolean;
            }
            case INTEGER: {
                return object instanceof Integer;
            }
            case LONG: {
                return object instanceof Long;
            }
            case BIG_DECIMAL: {
                return object instanceof BigDecimal;
            }
        }
        return object instanceof String;
    }

    static {
        TYPES_MAP = Arrays.stream(DataType.values()).collect(Collectors.toMap(value -> value.typeName, value -> value));
    }
}

