/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.otlp.http;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.function.Function;
import java.util.zip.GZIPOutputStream;
import org.opensearch.dataprepper.plugins.sink.otlp.metrics.OtlpSinkMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GzipCompressor
implements Function<byte[], byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(GzipCompressor.class);
    private final OtlpSinkMetrics sinkMetrics;

    GzipCompressor(OtlpSinkMetrics sinkMetrics) {
        this.sinkMetrics = sinkMetrics;
    }

    @Override
    public byte[] apply(byte[] payload) {
        try {
            return this.compressInternal(payload);
        }
        catch (IOException e) {
            LOG.error("Failed to compress payload", (Throwable)e);
            this.sinkMetrics.incrementErrorsCount();
            return new byte[0];
        }
    }

    @VisibleForTesting
    byte[] compressInternal(byte[] payload) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
                gzip.write(payload);
                gzip.finish();
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }
}

