/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.atlassian.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.AssertTrue;
import org.opensearch.dataprepper.model.plugin.PluginConfigVariable;

public class Oauth2Config {
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="client_secret")
    private String clientSecret;
    @JsonProperty(value="access_token")
    private PluginConfigVariable accessToken;
    @JsonProperty(value="refresh_token")
    private PluginConfigVariable refreshToken;

    @AssertTrue(message="Client ID, Client Secret, Access Token, and Refresh Token are both required for Oauth2")
    private @AssertTrue(message="Client ID, Client Secret, Access Token, and Refresh Token are both required for Oauth2") boolean isOauth2ConfigValid() {
        return this.clientId != null && this.clientSecret != null && this.accessToken != null && this.refreshToken != null;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public PluginConfigVariable getAccessToken() {
        return this.accessToken;
    }

    public PluginConfigVariable getRefreshToken() {
        return this.refreshToken;
    }
}

