/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.allocation_explain;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ReservedSize
implements PlainJsonSerializable {
    private final String nodeId;
    private final String path;
    private final long total;
    private final List<String> shards;
    public static final JsonpDeserializer<ReservedSize> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReservedSize::setupReservedSizeDeserializer);

    private ReservedSize(Builder builder) {
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.path = ApiTypeHelper.requireNonNull(builder.path, this, "path");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.shards = ApiTypeHelper.unmodifiableRequired(builder.shards, (Object)this, "shards");
    }

    public static ReservedSize of(Function<Builder, ObjectBuilder<ReservedSize>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String path() {
        return this.path;
    }

    public final long total() {
        return this.total;
    }

    public final List<String> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("path");
        generator.write(this.path);
        generator.writeKey("total");
        generator.write(this.total);
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartArray();
            for (String item0 : this.shards) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupReservedSizeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::shards, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "shards");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ReservedSize> {
        private String nodeId;
        private String path;
        private Long total;
        private List<String> shards;

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder path(String value) {
            this.path = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        public final Builder shards(List<String> list) {
            this.shards = Builder._listAddAll(this.shards, list);
            return this;
        }

        public final Builder shards(String value, String ... values) {
            this.shards = Builder._listAdd(this.shards, value, values);
            return this;
        }

        @Override
        public ReservedSize build() {
            this._checkSingleUse();
            return new ReservedSize(this);
        }
    }
}

