/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsHandler
implements HttpHandler {
    private final PrometheusMeterRegistry prometheusMeterRegistry;
    private final Logger LOG = LoggerFactory.getLogger(PrometheusMetricsHandler.class);

    public PrometheusMetricsHandler(PrometheusMeterRegistry prometheusMeterRegistry) {
        this.prometheusMeterRegistry = prometheusMeterRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String requestMethod = exchange.getRequestMethod();
        if (!requestMethod.equals("GET") && !requestMethod.equals("POST")) {
            exchange.sendResponseHeaders(405, 0L);
            exchange.getResponseBody().close();
            return;
        }
        try {
            byte[] response = this.prometheusMeterRegistry.scrape().getBytes(StandardCharsets.UTF_8);
            exchange.getResponseHeaders().add("Content-Type", "text/plain; charset=UTF-8");
            exchange.sendResponseHeaders(200, response.length);
            exchange.getResponseBody().write(response);
        }
        catch (Exception e) {
            this.LOG.error("Encountered exception scraping prometheus meter registry", (Throwable)e);
            exchange.sendResponseHeaders(500, 0L);
        }
        finally {
            exchange.getResponseBody().close();
        }
    }
}

