/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.router;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.opensearch.dataprepper.core.parser.DataFlowComponent;
import org.opensearch.dataprepper.core.pipeline.router.DataFlowComponentRouter;
import org.opensearch.dataprepper.core.pipeline.router.RouteEventEvaluator;
import org.opensearch.dataprepper.core.pipeline.router.RouterGetRecordStrategy;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;

public class Router {
    private final RouteEventEvaluator routeEventEvaluator;
    private final DataFlowComponentRouter dataFlowComponentRouter;
    private final Consumer<Event> noRouteHandler;

    Router(RouteEventEvaluator routeEventEvaluator, DataFlowComponentRouter dataFlowComponentRouter, Consumer<Event> noRouteHandler) {
        this.routeEventEvaluator = Objects.requireNonNull(routeEventEvaluator);
        this.dataFlowComponentRouter = dataFlowComponentRouter;
        this.noRouteHandler = noRouteHandler;
    }

    public <C> void route(Collection<Record> allRecords, Collection<DataFlowComponent<C>> dataFlowComponents, RouterGetRecordStrategy getRecordStrategy, BiConsumer<C, Collection<Record>> componentRecordsConsumer) {
        Objects.requireNonNull(allRecords);
        Objects.requireNonNull(dataFlowComponents);
        Objects.requireNonNull(componentRecordsConsumer);
        Map<Record, Set<String>> recordsToRoutes = this.routeEventEvaluator.evaluateEventRoutes(allRecords);
        boolean allRecordsRouted = false;
        for (DataFlowComponent<C> dataFlowComponent : dataFlowComponents) {
            if (!dataFlowComponent.getRoutes().isEmpty()) continue;
            allRecordsRouted = true;
            break;
        }
        HashSet<Record> recordsUnRouted = allRecordsRouted ? null : new HashSet<Record>(allRecords);
        for (DataFlowComponent<C> dataFlowComponent : dataFlowComponents) {
            this.dataFlowComponentRouter.route(allRecords, dataFlowComponent, recordsToRoutes, getRecordStrategy, (component, records) -> {
                if (recordsUnRouted != null) {
                    for (Record record : records) {
                        recordsUnRouted.remove(record);
                    }
                }
                componentRecordsConsumer.accept((Object)component, (Collection<Record>)records);
            });
        }
        if (recordsUnRouted != null) {
            for (Record record : recordsUnRouted) {
                if (!(record.getData() instanceof Event)) continue;
                this.noRouteHandler.accept((Event)record.getData());
            }
        }
    }
}

