/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder.server;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.Post;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderProvider;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderReceiveBuffer;
import org.opensearch.dataprepper.core.peerforwarder.codec.PeerForwarderCodec;
import org.opensearch.dataprepper.core.peerforwarder.model.PeerForwardingEvents;
import org.opensearch.dataprepper.core.peerforwarder.server.ResponseHandler;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerForwarderHttpService {
    private static final Logger LOG = LoggerFactory.getLogger(PeerForwarderHttpService.class);
    static final String SERVER_REQUEST_PROCESSING_LATENCY = "serverRequestProcessingLatency";
    static final String RECORDS_RECEIVED_FROM_PEERS = "recordsReceivedFromPeers";
    private static final double BUFFER_TIMEOUT_FRACTION = 0.8;
    private final ResponseHandler responseHandler;
    private final PeerForwarderProvider peerForwarderProvider;
    private final PeerForwarderConfiguration peerForwarderConfiguration;
    private final PeerForwarderCodec peerForwarderCodec;
    private final Timer serverRequestProcessingLatencyTimer;
    private final Counter recordsReceivedFromPeersCounter;
    private final AcknowledgementSetManager acknowledgementSetManager;

    public PeerForwarderHttpService(ResponseHandler responseHandler, PeerForwarderProvider peerForwarderProvider, PeerForwarderConfiguration peerForwarderConfiguration, PeerForwarderCodec peerForwarderCodec, AcknowledgementSetManager acknowledgementSetManager, PluginMetrics pluginMetrics) {
        this.responseHandler = responseHandler;
        this.peerForwarderProvider = peerForwarderProvider;
        this.peerForwarderConfiguration = peerForwarderConfiguration;
        this.peerForwarderCodec = peerForwarderCodec;
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.serverRequestProcessingLatencyTimer = pluginMetrics.timer(SERVER_REQUEST_PROCESSING_LATENCY);
        this.recordsReceivedFromPeersCounter = pluginMetrics.counter(RECORDS_RECEIVED_FROM_PEERS);
    }

    @Post
    public HttpResponse doPost(AggregatedHttpRequest aggregatedHttpRequest) {
        return (HttpResponse)this.serverRequestProcessingLatencyTimer.record(() -> this.processRequest(aggregatedHttpRequest));
    }

    private HttpResponse processRequest(AggregatedHttpRequest aggregatedHttpRequest) {
        String destinationPipelineName;
        String destinationPluginId;
        HttpData content = aggregatedHttpRequest.content();
        ArrayList<Event> events = new ArrayList<Event>();
        try {
            PeerForwardingEvents peerForwardingEvents = this.peerForwarderCodec.deserialize(content.array());
            destinationPluginId = peerForwardingEvents.getDestinationPluginId();
            destinationPipelineName = peerForwardingEvents.getDestinationPipelineName();
            if (peerForwardingEvents.getEvents() != null) {
                events.addAll(peerForwardingEvents.getEvents());
            }
        }
        catch (Exception e) {
            String message = "Failed to write the request content due to bad request data format. Needs to be JSON object";
            LOG.error("Failed to write the request content due to bad request data format. Needs to be JSON object", (Throwable)e);
            return this.responseHandler.handleException(e, "Failed to write the request content due to bad request data format. Needs to be JSON object");
        }
        try {
            this.writeEventsToBuffer(events, destinationPluginId, destinationPipelineName);
        }
        catch (Exception e) {
            String message = String.format("Failed to write the request of size %d due to:", content.length());
            LOG.error(message, (Throwable)e);
            return this.responseHandler.handleException(e, message);
        }
        return HttpResponse.of((HttpStatus)HttpStatus.OK);
    }

    private void writeEventsToBuffer(Collection<Event> events, String destinationPluginId, String destinationPipelineName) throws Exception {
        PeerForwarderReceiveBuffer<Record<Event>> recordPeerForwarderReceiveBuffer = this.getPeerForwarderBuffer(destinationPluginId, destinationPipelineName);
        Collection jacksonEvents = events.stream().map(Record::new).collect(Collectors.toList());
        recordPeerForwarderReceiveBuffer.writeAll(jacksonEvents, this.getBufferTimeoutMillis());
        this.recordsReceivedFromPeersCounter.increment((double)jacksonEvents.size());
    }

    private int getBufferTimeoutMillis() {
        return (int)((double)this.peerForwarderConfiguration.getRequestTimeout() * 0.8);
    }

    private PeerForwarderReceiveBuffer<Record<Event>> getPeerForwarderBuffer(String destinationPluginId, String destinationPipelineName) {
        Map<String, Map<String, PeerForwarderReceiveBuffer<Record<Event>>>> pipelinePeerForwarderReceiveBufferMap = this.peerForwarderProvider.getPipelinePeerForwarderReceiveBufferMap();
        return pipelinePeerForwarderReceiveBufferMap.get(destinationPipelineName).get(destinationPluginId);
    }
}

