/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.acknowledgements;

import java.time.Duration;
import org.opensearch.dataprepper.core.acknowledgements.AcknowledgementSetMonitor;

class AcknowledgementSetMonitorThread {
    private final Thread monitorThread;
    private final AcknowledgementSetMonitor acknowledgementSetMonitor;
    private final Duration delayTime;
    private volatile boolean isStopped = false;

    public AcknowledgementSetMonitorThread(AcknowledgementSetMonitor acknowledgementSetMonitor, Duration delayTime) {
        this.acknowledgementSetMonitor = acknowledgementSetMonitor;
        this.delayTime = delayTime;
        this.monitorThread = new Thread(new Monitor());
        this.monitorThread.setDaemon(true);
        this.monitorThread.setName("acknowledgement-monitor");
    }

    public void start() {
        this.monitorThread.start();
    }

    public void stop() {
        this.isStopped = true;
    }

    private class Monitor
    implements Runnable {
        private Monitor() {
        }

        @Override
        public void run() {
            while (!AcknowledgementSetMonitorThread.this.isStopped) {
                AcknowledgementSetMonitorThread.this.acknowledgementSetMonitor.run();
                try {
                    Thread.sleep(AcknowledgementSetMonitorThread.this.delayTime.toMillis());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

