/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping.mutate;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.logstash.mapping.LogstashAttributesMappings;
import org.opensearch.dataprepper.logstash.mapping.LogstashPluginAttributesMapper;
import org.opensearch.dataprepper.logstash.mapping.mutate.AbstractConversion;
import org.opensearch.dataprepper.logstash.mapping.mutate.AddEntryConversion;
import org.opensearch.dataprepper.logstash.mapping.mutate.CopyValueConversion;
import org.opensearch.dataprepper.logstash.mapping.mutate.DeleteEntryConversion;
import org.opensearch.dataprepper.logstash.mapping.mutate.LowercaseStringConversion;
import org.opensearch.dataprepper.logstash.mapping.mutate.RenameKeyConversion;
import org.opensearch.dataprepper.logstash.mapping.mutate.SplitStringConversion;
import org.opensearch.dataprepper.logstash.mapping.mutate.SubstituteStringConversion;
import org.opensearch.dataprepper.logstash.mapping.mutate.TrimStringConversion;
import org.opensearch.dataprepper.logstash.mapping.mutate.UppercaseStringConversion;
import org.opensearch.dataprepper.logstash.model.LogstashAttribute;
import org.opensearch.dataprepper.model.configuration.PluginModel;

public class MutateMapper
implements LogstashPluginAttributesMapper {
    private final Map<String, AbstractConversion> conversionMap = new HashMap<String, AbstractConversion>();

    public MutateMapper() {
        this.conversionMap.put(RenameKeyConversion.getLogstashName(), new RenameKeyConversion());
        this.conversionMap.put(CopyValueConversion.getLogstashName(), new CopyValueConversion());
        this.conversionMap.put(AddEntryConversion.getLogstashName(), new AddEntryConversion());
        this.conversionMap.put(DeleteEntryConversion.getLogstashName(), new DeleteEntryConversion());
        this.conversionMap.put(SubstituteStringConversion.getLogstashName(), new SubstituteStringConversion());
        this.conversionMap.put(LowercaseStringConversion.getLogstashName(), new LowercaseStringConversion());
        this.conversionMap.put(UppercaseStringConversion.getLogstashName(), new UppercaseStringConversion());
        this.conversionMap.put(TrimStringConversion.getLogstashName(), new TrimStringConversion());
        this.conversionMap.put(SplitStringConversion.getLogstashName(), new SplitStringConversion());
    }

    @Override
    public List<PluginModel> mapAttributes(List<LogstashAttribute> logstashAttributes, LogstashAttributesMappings logstashAttributesMappings) {
        LinkedList<AbstractConversion> converters = new LinkedList<AbstractConversion>();
        for (LogstashAttribute attr : logstashAttributes) {
            String name = attr.getAttributeName();
            if (!this.conversionMap.containsKey(name)) continue;
            AbstractConversion converter = this.conversionMap.get(name);
            converter.addToModel(attr);
            if (converters.contains(converter)) continue;
            converters.add(converter);
        }
        LinkedList<PluginModel> models = new LinkedList<PluginModel>();
        for (AbstractConversion converter : converters) {
            models.add(converter.generateModel());
        }
        return models;
    }
}

