/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping.mutate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.logstash.mapping.NestedSyntaxConverter;
import org.opensearch.dataprepper.logstash.mapping.mutate.SubMutateAction;
import org.opensearch.dataprepper.logstash.model.LogstashAttribute;
import org.opensearch.dataprepper.model.configuration.PluginModel;

public abstract class AbstractConversion<T>
implements SubMutateAction {
    protected List<T> entries = new LinkedList<T>();

    @Override
    public void addToModel(LogstashAttribute attribute) {
        if (attribute.getAttributeValue().getValue() instanceof Map) {
            ((Map)attribute.getAttributeValue().getValue()).forEach((key, value) -> {
                if (value instanceof String) {
                    this.addKvToEntries(NestedSyntaxConverter.convertNestedSyntaxToJsonPointer(key), NestedSyntaxConverter.convertNestedSyntaxToJsonPointer((String)value));
                } else {
                    this.addKvToEntries(NestedSyntaxConverter.convertNestedSyntaxToJsonPointer(key), value);
                }
            });
        } else if (attribute.getAttributeValue().getValue() instanceof ArrayList) {
            this.addListToEntries(((ArrayList)attribute.getAttributeValue().getValue()).stream().map(NestedSyntaxConverter::convertNestedSyntaxToJsonPointer).collect(Collectors.toList()));
        }
    }

    @Override
    public PluginModel generateModel() {
        HashMap<String, List<T>> entryMap = new HashMap<String, List<T>>();
        entryMap.put(this.getMapKey(), this.entries);
        PluginModel model = new PluginModel(this.getDataPrepperName(), entryMap);
        return model;
    }

    protected abstract void addKvToEntries(String var1, Object var2);

    protected abstract void addListToEntries(List<String> var1);

    protected abstract String getDataPrepperName();

    protected abstract String getMapKey();
}

