/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.mapping;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opensearch.dataprepper.logstash.exception.LogstashMappingException;
import org.opensearch.dataprepper.logstash.mapping.LogstashMappingModel;
import org.opensearch.dataprepper.logstash.mapping.LogstashPluginAttributesMapper;
import org.opensearch.dataprepper.logstash.mapping.PluginMapperProvider;
import org.opensearch.dataprepper.logstash.model.LogstashPlugin;
import org.opensearch.dataprepper.model.configuration.PluginModel;

class LogstashPluginMapper {
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final PluginMapperProvider pluginMapperProvider;

    public LogstashPluginMapper() {
        this(new PluginMapperProvider());
    }

    public LogstashPluginMapper(PluginMapperProvider pluginMapperProvider) {
        this.pluginMapperProvider = pluginMapperProvider;
    }

    public List<PluginModel> mapPlugin(LogstashPlugin logstashPlugin) {
        LogstashMappingModel logstashMappingModel;
        String mappingResourceName = logstashPlugin.getPluginName() + ".mapping.yaml";
        InputStream inputStream = this.getClass().getResourceAsStream(mappingResourceName);
        if (inputStream == null) {
            throw new LogstashMappingException("Unable to find mapping resource " + mappingResourceName);
        }
        try {
            logstashMappingModel = (LogstashMappingModel)this.objectMapper.readValue(inputStream, LogstashMappingModel.class);
        }
        catch (IOException ex) {
            throw new LogstashMappingException("Unable to parse mapping file " + mappingResourceName, ex);
        }
        if (logstashMappingModel.getCustomPluginMapperClass() != null) {
            LogstashPluginAttributesMapper mapper = this.pluginMapperProvider.getAttributesMapper(logstashMappingModel);
            return mapper.mapAttributes(logstashPlugin.getAttributes(), logstashMappingModel);
        }
        if (logstashMappingModel.getPluginName() == null) {
            throw new LogstashMappingException("The mapping file " + mappingResourceName + " has a null value for 'pluginName'.");
        }
        LogstashPluginAttributesMapper pluginAttributesMapper = this.pluginMapperProvider.getAttributesMapper(logstashMappingModel);
        List<PluginModel> pluginModels = pluginAttributesMapper.mapAttributes(logstashPlugin.getAttributes(), logstashMappingModel);
        return pluginModels;
    }
}

