/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.unsafe.grpc;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.util.AttributeKey;
import java.util.IdentityHashMap;

@UnstableApi
public final class GrpcUnsafeBufferUtil {
    @VisibleForTesting
    public static final AttributeKey<IdentityHashMap<Object, ByteBuf>> BUFFERS = AttributeKey.valueOf(GrpcUnsafeBufferUtil.class, (String)"BUFFERS");

    public static void storeBuffer(ByteBuf buf, Object message, RequestContext ctx) {
        IdentityHashMap<Object, ByteBuf> buffers = (IdentityHashMap<Object, ByteBuf>)ctx.attr(BUFFERS);
        if (buffers == null) {
            buffers = new IdentityHashMap<Object, ByteBuf>();
            ctx.setAttr(BUFFERS, buffers);
        }
        buffers.put(message, buf);
    }

    public static void releaseBuffer(Object message, RequestContext ctx) {
        IdentityHashMap buffers = (IdentityHashMap)ctx.attr(BUFFERS);
        if (buffers == null) {
            return;
        }
        ByteBuf removed = (ByteBuf)buffers.remove(message);
        if (removed == null) {
            return;
        }
        removed.release();
    }

    private GrpcUnsafeBufferUtil() {
    }
}

