/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import com.linecorp.armeria.client.grpc.GrpcClientStubFactory;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.client.grpc.GrpcClientFactoryUtil;
import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.ServiceDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class KotlinGrpcClientStubFactory
implements GrpcClientStubFactory {
    @Override
    @Nullable
    public ServiceDescriptor findServiceDescriptor(Class<?> clientType) {
        if (clientType.getName().endsWith("CoroutineStub")) {
            Method getServiceDescriptor;
            Class<?> generatedStub;
            Annotation annotation = KotlinGrpcClientStubFactory.stubForAnnotation(clientType);
            try {
                Method valueMethod = annotation.annotationType().getDeclaredMethod("value", null);
                generatedStub = KotlinGrpcClientStubFactory.generatedStub(annotation, valueMethod);
                getServiceDescriptor = generatedStub.getDeclaredMethod("getServiceDescriptor", null);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Could not find value getter on StubFor annotation.", e);
            }
            try {
                return (ServiceDescriptor)getServiceDescriptor.invoke(generatedStub, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Could not invoke getServiceDescriptor on a gRPC Kotlin client stub.", e);
            }
        }
        return null;
    }

    private static Annotation stubForAnnotation(Class<?> clientType) {
        try {
            Class<?> annotationClass = Class.forName(BindableService.class.getPackage().getName() + ".kotlin.StubFor");
            Object annotation = clientType.getAnnotation(annotationClass);
            if (annotation == null) {
                throw new IllegalArgumentException("Could not find StubFor annotation on a gRPC Kotlin client stub.");
            }
            return annotation;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find StubFor annotation on a gRPC Kotlin client stub.", e);
        }
    }

    private static Class<?> generatedStub(Annotation annotation, Method valueMethod) {
        try {
            return (Class)valueMethod.invoke((Object)annotation, null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not find a gRPC Kotlin generated client stub.", Exceptions.peel((Throwable)e));
        }
    }

    @Override
    public Object newClientStub(Class<?> clientType, Channel channel) {
        Constructor<?> constructor = null;
        for (Constructor<?> ctor : clientType.getConstructors()) {
            Class<?>[] methodParameterTypes = ctor.getParameterTypes();
            if (methodParameterTypes.length != 1 || methodParameterTypes[0] != Channel.class) continue;
            constructor = ctor;
            break;
        }
        if (constructor == null) {
            throw new IllegalStateException("Could not find a constructor on a gRPC Kotlin client stub: " + clientType.getName());
        }
        try {
            return constructor.newInstance(channel);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw GrpcClientFactoryUtil.newClientStubCreationException(e);
        }
    }
}

